/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.security.acegi.acls.objectidentity;

import com.atlassian.bamboo.chains.DefaultChain;
import com.atlassian.bamboo.core.BambooIdProvider;
import com.atlassian.bamboo.deployments.environments.InternalEnvironment;
import com.atlassian.bamboo.deployments.projects.InternalDeploymentProject;
import com.atlassian.bamboo.plan.PlanKeyProvider;
import com.atlassian.bamboo.project.DefaultProject;
import com.atlassian.bamboo.project.ProjectIdentifier;
import com.atlassian.bamboo.project.ProjectPlanPermissions;
import com.atlassian.bamboo.repository.RepositoryDataEntity;
import com.atlassian.bamboo.repository.RepositoryDataEntityImpl;
import com.atlassian.bamboo.security.GlobalApplicationSecureObject;
import com.atlassian.bamboo.vcs.configuration.VcsRepositoryData;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

public final class ObjectIdentityUtils {
    public static final Map<Class<?>, Class<?>> ACL_OBJECT_IDENTITY_CLASSES = ImmutableMap.builder().put(GlobalApplicationSecureObject.class, GlobalApplicationSecureObject.class).put(ProjectIdentifier.class, DefaultProject.class).put(ProjectPlanPermissions.class, ProjectPlanPermissions.class).put(PlanKeyProvider.class, DefaultChain.class).put(InternalDeploymentProject.class, InternalDeploymentProject.class).put(InternalEnvironment.class, InternalEnvironment.class).put(RepositoryDataEntity.class, RepositoryDataEntityImpl.class).put(VcsRepositoryData.class, RepositoryDataEntityImpl.class).build();

    private ObjectIdentityUtils() {
    }

    @NotNull
    public static Optional<Class<?>> getAclClassForEntity(@NotNull BambooIdProvider entity) {
        return ObjectIdentityUtils.getAclClassForEntityClass(entity.getClass());
    }

    @NotNull
    public static Optional<Class<?>> getAclClassForEntityClass(@NotNull Class<?> entityClass) {
        return ACL_OBJECT_IDENTITY_CLASSES.keySet().stream().filter(baseClass -> baseClass.isAssignableFrom(entityClass)).findFirst().map(ACL_OBJECT_IDENTITY_CLASSES::get);
    }
}

