/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.security.acegi.afterinvocation;

import com.atlassian.bamboo.chains.ChainResultsSummary;
import com.atlassian.bamboo.plan.PlanIdentifier;
import com.atlassian.bamboo.plan.PlanKey;
import com.atlassian.bamboo.plan.PlanKeys;
import com.atlassian.bamboo.plan.cache.CachedPlanManager;
import com.atlassian.bamboo.plan.cache.ImmutablePlan;
import com.atlassian.bamboo.project.ProjectIdentifier;
import com.atlassian.bamboo.project.ProjectPlanPermissions;
import com.atlassian.bamboo.resultsummary.ResultsSummary;
import com.atlassian.bamboo.security.acegi.BambooAcegiSecurityUtils;
import com.atlassian.bamboo.spring.ComponentAccessor;
import com.atlassian.bamboo.user.Authority;
import com.google.common.base.Supplier;
import org.acegisecurity.Authentication;
import org.acegisecurity.acls.Acl;
import org.acegisecurity.acls.AclService;
import org.acegisecurity.acls.NotFoundException;
import org.acegisecurity.acls.Permission;
import org.acegisecurity.acls.domain.BasePermission;
import org.acegisecurity.acls.objectidentity.ObjectIdentity;
import org.acegisecurity.acls.objectidentity.ObjectIdentityRetrievalStrategy;
import org.acegisecurity.acls.sid.Sid;
import org.acegisecurity.acls.sid.SidRetrievalStrategy;
import org.acegisecurity.afterinvocation.AclEntryAfterInvocationCollectionFilteringProvider;

public class GenericAclEntryAfterInvocationCollectionFilteringProvider
extends AclEntryAfterInvocationCollectionFilteringProvider {
    private static final Permission[] VIEW_PERMISSION = new Permission[]{BasePermission.READ};
    private final Supplier<CachedPlanManager> planManager = ComponentAccessor.CACHED_PLAN_MANAGER;
    private final AclService aclService;
    private ObjectIdentityRetrievalStrategy localObjectIdentityRetrievalStrategy;
    private SidRetrievalStrategy localSidRetrievalStrategy;

    public GenericAclEntryAfterInvocationCollectionFilteringProvider(AclService aclService, String processConfigAttrib, Permission[] requirePermission) {
        super(aclService, requirePermission);
        this.aclService = aclService;
        this.setProcessConfigAttribute(processConfigAttrib);
    }

    protected boolean hasPermission(Authentication authentication, Object domainObject) {
        if (BambooAcegiSecurityUtils.hasAuthority(authentication, Authority.RESTRICTED_ADMIN)) {
            return true;
        }
        if (domainObject instanceof ResultsSummary) {
            return this.hasPermission(authentication, (ResultsSummary)domainObject);
        }
        if (domainObject instanceof PlanIdentifier) {
            ProjectIdentifier projectIdentifier = ((PlanIdentifier)domainObject).getProject();
            if (!this.hasViewPermission(authentication, projectIdentifier)) {
                return false;
            }
            if (super.hasPermission(authentication, (Object)new ProjectPlanPermissions(projectIdentifier))) {
                return true;
            }
        }
        return super.hasPermission(authentication, domainObject);
    }

    private boolean hasViewPermission(Authentication authentication, Object domainObject) {
        ObjectIdentity objectIdentity = this.localObjectIdentityRetrievalStrategy.getObjectIdentity(domainObject);
        Sid[] sids = this.localSidRetrievalStrategy.getSids(authentication);
        try {
            Acl acl = this.aclService.readAclById(objectIdentity, sids);
            return acl.isGranted(VIEW_PERMISSION, sids, false);
        }
        catch (NotFoundException ignore) {
            return false;
        }
    }

    private boolean hasPermission(Authentication authentication, ResultsSummary rs) {
        PlanKey chainKey = rs instanceof ChainResultsSummary ? rs.getPlanKey() : PlanKeys.getChainKeyFromJobKey((PlanKey)rs.getPlanKey());
        ImmutablePlan plan = ((CachedPlanManager)this.planManager.get()).getPlanByKey(chainKey);
        return this.hasPermission(authentication, plan);
    }

    public void setObjectIdentityRetrievalStrategy(ObjectIdentityRetrievalStrategy objectIdentityRetrievalStrategy) {
        super.setObjectIdentityRetrievalStrategy(objectIdentityRetrievalStrategy);
        this.localObjectIdentityRetrievalStrategy = objectIdentityRetrievalStrategy;
    }

    public void setSidRetrievalStrategy(SidRetrievalStrategy sidRetrievalStrategy) {
        super.setSidRetrievalStrategy(sidRetrievalStrategy);
        this.localSidRetrievalStrategy = sidRetrievalStrategy;
    }
}

