/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.security.acegi.afterinvocation;

import com.atlassian.bamboo.security.GlobalApplicationSecureObject;
import com.atlassian.bamboo.security.acegi.BambooAcegiSecurityUtils;
import com.atlassian.bamboo.security.acegi.acls.HibernateObjectIdentityImpl;
import com.atlassian.bamboo.user.Authority;
import com.atlassian.bamboo.util.Narrow;
import org.acegisecurity.Authentication;
import org.acegisecurity.acls.Acl;
import org.acegisecurity.acls.AclService;
import org.acegisecurity.acls.NotFoundException;
import org.acegisecurity.acls.Permission;
import org.acegisecurity.acls.objectidentity.ObjectIdentity;
import org.acegisecurity.acls.objectidentity.ObjectIdentityRetrievalStrategy;
import org.acegisecurity.acls.objectidentity.ObjectIdentityRetrievalStrategyImpl;
import org.acegisecurity.acls.sid.Sid;
import org.acegisecurity.acls.sid.SidRetrievalStrategy;
import org.acegisecurity.acls.sid.SidRetrievalStrategyImpl;
import org.acegisecurity.afterinvocation.AclEntryAfterInvocationProvider;

public class GenericAclEntryAfterInvocationProvider
extends AclEntryAfterInvocationProvider {
    private final Permission[] requirePermission;
    private final AclService aclService;
    private ObjectIdentityRetrievalStrategy objectIdentityRetrievalStrategy = new ObjectIdentityRetrievalStrategyImpl();
    private SidRetrievalStrategy sidRetrievalStrategy = new SidRetrievalStrategyImpl();

    public GenericAclEntryAfterInvocationProvider(AclService aclService, String processConfigAttribute, Permission[] requirePermission) {
        super(aclService, requirePermission);
        this.aclService = aclService;
        this.requirePermission = requirePermission;
        this.setProcessConfigAttribute(processConfigAttribute);
    }

    protected boolean hasPermission(Authentication authentication, Object domainObject) {
        if (BambooAcegiSecurityUtils.hasAuthority(authentication, Authority.RESTRICTED_ADMIN) && !(domainObject instanceof GlobalApplicationSecureObject)) {
            return true;
        }
        ObjectIdentity objectIdentity = this.objectIdentityRetrievalStrategy.getObjectIdentity(domainObject);
        HibernateObjectIdentityImpl hibernateObjectIdentity = (HibernateObjectIdentityImpl)Narrow.to((Object)objectIdentity, HibernateObjectIdentityImpl.class);
        if (hibernateObjectIdentity != null) {
            return this.hasPermission(authentication, hibernateObjectIdentity);
        }
        return this.hasPermission(authentication, objectIdentity);
    }

    private boolean hasPermission(Authentication authentication, HibernateObjectIdentityImpl objectIdentity) {
        boolean isGranted = this.hasPermission(authentication, (ObjectIdentity)objectIdentity);
        HibernateObjectIdentityImpl ancestorIdentity = objectIdentity.getAncestorIdentity();
        if (ancestorIdentity != null) {
            switch (objectIdentity.getHighestRankPermissionCheckPolicy(this.requirePermission)) {
                case AND: {
                    isGranted = isGranted && this.hasPermission(authentication, ancestorIdentity);
                    break;
                }
                case OR: {
                    isGranted = isGranted || this.hasPermission(authentication, ancestorIdentity);
                }
            }
        }
        return isGranted;
    }

    private boolean hasPermission(Authentication authentication, ObjectIdentity objectIdentity) {
        Sid[] sids = this.sidRetrievalStrategy.getSids(authentication);
        try {
            Acl acl = this.aclService.readAclById(objectIdentity, sids);
            return acl.isGranted(this.requirePermission, sids, false);
        }
        catch (NotFoundException ignore) {
            return false;
        }
    }

    public void setObjectIdentityRetrievalStrategy(ObjectIdentityRetrievalStrategy objectIdentityRetrievalStrategy) {
        super.setObjectIdentityRetrievalStrategy(objectIdentityRetrievalStrategy);
        this.objectIdentityRetrievalStrategy = objectIdentityRetrievalStrategy;
    }

    public void setSidRetrievalStrategy(SidRetrievalStrategy sidRetrievalStrategy) {
        super.setSidRetrievalStrategy(sidRetrievalStrategy);
        this.sidRetrievalStrategy = sidRetrievalStrategy;
    }
}

