/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.security.acegi.intercept.aopalliance;

import org.acegisecurity.Authentication;
import org.acegisecurity.GrantedAuthority;
import org.acegisecurity.context.SecurityContextHolder;
import org.acegisecurity.intercept.method.aopalliance.MethodSecurityInterceptor;
import org.aopalliance.intercept.MethodInvocation;

public class AuthorityOverrideMethodSecurityInterceptor
extends MethodSecurityInterceptor {
    private GrantedAuthority[] overrideAuthorities = new GrantedAuthority[0];

    public Object invoke(MethodInvocation mi) throws Throwable {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (authentication != null) {
            for (int i = 0; i < authentication.getAuthorities().length; ++i) {
                for (GrantedAuthority overrideAuth : this.overrideAuthorities) {
                    if (!overrideAuth.getAuthority().equals(authentication.getAuthorities()[i].getAuthority())) continue;
                    return mi.proceed();
                }
            }
        }
        return super.invoke(mi);
    }

    public GrantedAuthority[] getOverrideAuthorities() {
        return this.overrideAuthorities;
    }

    public void setOverrideAuthorities(GrantedAuthority[] overrideAuthorities) {
        this.overrideAuthorities = overrideAuthorities;
    }
}

