/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.security.applinks;

import com.atlassian.applinks.api.ApplicationId;
import com.atlassian.applinks.api.ApplicationType;
import com.atlassian.applinks.api.EntityType;
import com.atlassian.applinks.api.application.bamboo.BambooApplicationType;
import com.atlassian.applinks.api.application.bamboo.BambooProjectEntityType;
import com.atlassian.applinks.host.spi.AbstractInternalHostApplication;
import com.atlassian.applinks.host.spi.DefaultEntityReference;
import com.atlassian.applinks.host.spi.EntityReference;
import com.atlassian.applinks.spi.util.TypeAccessor;
import com.atlassian.bamboo.configuration.AdministrationConfigurationAccessor;
import com.atlassian.bamboo.project.Project;
import com.atlassian.bamboo.project.ProjectManager;
import com.atlassian.bamboo.security.BambooPermissionManager;
import com.atlassian.bamboo.security.acegi.acls.BambooPermission;
import com.atlassian.bamboo.setup.BootstrapManager;
import com.atlassian.bamboo.util.TextProviderUtils;
import com.atlassian.bamboo.utils.BambooPreconditions;
import com.atlassian.plugin.PluginAccessor;
import com.google.common.base.Preconditions;
import com.opensymphony.xwork2.TextProvider;
import java.net.URI;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.acegisecurity.acls.Permission;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Lazy;

public class BambooHostApplication
extends AbstractInternalHostApplication {
    @Qualifier(value="bambooPermissionManager")
    @Lazy
    @Inject
    private BambooPermissionManager permissionManager;
    private final TypeAccessor typeAccessor;
    private final ProjectManager projectManager;
    private final AdministrationConfigurationAccessor administrationConfigurationAccessor;
    private final BootstrapManager bootstrapManager;
    private final com.atlassian.struts.TextProvider textProvider;

    @Inject
    public BambooHostApplication(PluginAccessor pluginAccessor, TypeAccessor typeAccessor, ProjectManager projectManager, AdministrationConfigurationAccessor administrationConfigurationAccessor, BootstrapManager bootstrapManager, com.atlassian.struts.TextProvider textProvider) {
        super(pluginAccessor);
        this.typeAccessor = typeAccessor;
        this.projectManager = projectManager;
        this.administrationConfigurationAccessor = administrationConfigurationAccessor;
        this.bootstrapManager = bootstrapManager;
        this.textProvider = textProvider;
    }

    public URI getDocumentationBaseUrl() {
        return URI.create("http://confluence.atlassian.com/display/APPLINKS");
    }

    public String getName() {
        return this.administrationConfigurationAccessor.getAdministrationConfiguration().getInstanceName();
    }

    public URI getBaseUrl() {
        return URI.create(this.administrationConfigurationAccessor.getAdministrationConfiguration().getBaseUrl());
    }

    public ApplicationId getId() {
        return new ApplicationId(UUID.nameUUIDFromBytes(this.bootstrapManager.getServerID().getBytes()).toString());
    }

    public ApplicationType getType() {
        return (ApplicationType)Preconditions.checkNotNull((Object)this.typeAccessor.getApplicationType(BambooApplicationType.class), (Object)"BambooApplicationType not installed");
    }

    public boolean hasPublicSignup() {
        return this.administrationConfigurationAccessor.getAdministrationConfiguration().isEnableSignup();
    }

    public Iterable<EntityReference> getLocalEntities() {
        return this.projectManager.getProjects().stream().map(this::toEntityReference).collect(Collectors.toList());
    }

    public EntityReference toEntityReference(@NotNull Object domainObject) {
        if (domainObject instanceof Project) {
            Project project = (Project)domainObject;
            return new DefaultEntityReference(project.getKey(), project.getName(), this.getEntityType());
        }
        throw new IllegalArgumentException("Unsupported argument type: " + domainObject.getClass().getName());
    }

    public EntityReference toEntityReference(String key, Class<? extends EntityType> type) {
        if (BambooProjectEntityType.class.isAssignableFrom(type)) {
            Project project = this.projectManager.getProjectByKey(key);
            BambooPreconditions.checkThat((project != null ? 1 : 0) != 0, IllegalArgumentException::new, TextProviderUtils.textSupplier((TextProvider)this.textProvider, "project.not.found", key));
            return this.toEntityReference(project);
        }
        throw new IllegalArgumentException("Unsupported argument type: " + type.getClass().getName());
    }

    public boolean canManageEntityLinksFor(EntityReference entityReference) {
        return this.permissionManager.hasProjectPermission((Permission)BambooPermission.ADMINISTRATION, entityReference.getKey());
    }

    public boolean doesEntityExist(String projectKey, Class<? extends EntityType> type) {
        return this.doesEntityExistNoPermissionCheck(projectKey, type);
    }

    public boolean doesEntityExistNoPermissionCheck(String key, Class<? extends EntityType> aClass) {
        return this.projectManager.getProjectByKey(key) != null;
    }

    private EntityType getEntityType() {
        return (EntityType)Preconditions.checkNotNull((Object)this.typeAccessor.getEntityType(BambooProjectEntityType.class), (Object)"BambooProjectEntityType not installed");
    }
}

