/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.security.ssl;

import com.atlassian.bamboo.util.Narrow;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.apache.log4j.Logger;

public class DefaultTrustManager
implements X509TrustManager {
    private final X509TrustManager defaultTrustManager = DefaultTrustManager.getDefaultTrustManager();
    private static final Logger log = Logger.getLogger(DefaultTrustManager.class);

    private static X509TrustManager getDefaultTrustManager() throws NoSuchAlgorithmException, KeyStoreException {
        TrustManager[] trustmanagers;
        TrustManagerFactory factory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        factory.init((KeyStore)null);
        for (TrustManager trustmanager : trustmanagers = factory.getTrustManagers()) {
            X509TrustManager x509TrustManager = (X509TrustManager)Narrow.downTo((Object)trustmanager, X509TrustManager.class);
            if (x509TrustManager == null) continue;
            return x509TrustManager;
        }
        throw new NoSuchAlgorithmException("Cannot find default trust manager.");
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        return this.defaultTrustManager.getAcceptedIssuers();
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        this.defaultTrustManager.checkClientTrusted(chain, authType);
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        try {
            this.defaultTrustManager.checkServerTrusted(chain, authType);
        }
        catch (CertificateException ex) {
            if (chain.length > 0) {
                String issuer = chain[0].getIssuerDN().toString();
                log.warn((Object)("Untrusted certificate (issued by [" + issuer + "]). Consider registering new Certificate Authority (CA)"), (Throwable)ex);
            } else {
                log.warn((Object)"Empty certificate chain", (Throwable)ex);
            }
            throw ex;
        }
    }
}

