/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.security.ssl;

import java.security.cert.Certificate;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import org.apache.http.conn.ssl.X509HostnameVerifier;
import org.apache.log4j.Logger;

public class LoggingHostNameVerifier
implements HostnameVerifier {
    private static final Logger log = Logger.getLogger(LoggingHostNameVerifier.class);
    private final String source;
    private final X509HostnameVerifier delegate;

    public LoggingHostNameVerifier(String source, X509HostnameVerifier delegate) {
        this.source = source;
        this.delegate = delegate;
    }

    @Override
    public boolean verify(String s, SSLSession sslSession) {
        boolean isOk = this.delegate.verify(s, sslSession);
        if (isOk) {
            log.debug((Object)("Accepted certificate for [" + s + "]"));
        } else {
            try {
                Certificate[] certificates = sslSession.getPeerCertificates();
                if (certificates.length == 0) {
                    log.error((Object)(this.source + ": rejecting peer - no peer certificates"));
                }
                log.error((Object)(this.source + ": rejected certificate [" + certificates[0] + "]"));
            }
            catch (SSLPeerUnverifiedException e) {
                log.error((Object)(this.source + ": unable to get peer certificate"), (Throwable)e);
            }
        }
        return isOk;
    }
}

