/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.security.trustedapplications;

import com.atlassian.bamboo.core.BambooEntityObject;
import com.atlassian.bamboo.security.trustedapplications.BambooTrustedApplication;
import com.google.common.collect.ImmutableSet;
import java.util.Collections;
import java.util.Set;
import javax.persistence.Entity;
import javax.persistence.Table;
import org.apache.commons.lang3.builder.CompareToBuilder;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.hibernate.annotations.GenericGenerator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Entity
@Table(name="TRUSTED_APPS")
@GenericGenerator(name="ImportAwareGenerator", strategy="com.atlassian.bamboo.persistence.ImportAwareGenerator")
public class BambooTrustedApplicationImpl
extends BambooEntityObject
implements BambooTrustedApplication {
    private String applicationId;
    private String publicKey;
    private String name;
    private Long timeout;
    private Set<String> urlPatterns;
    private Set<String> ipPatterns;

    public BambooTrustedApplicationImpl() {
        this("", "", null, 0L, Collections.emptySet(), Collections.emptySet());
    }

    public BambooTrustedApplicationImpl(@NotNull String applicationId, @NotNull String publicKey, @Nullable String name, @NotNull Long timeout, @NotNull Set<String> urlPatterns, @NotNull Set<String> ipPatterns) {
        this.setApplicationId(applicationId);
        this.setPublicKey(publicKey);
        this.setName(name);
        this.setTimeout(timeout);
        this.setUrlPatterns(urlPatterns);
        this.setIpPatterns(ipPatterns);
    }

    @NotNull
    public String getApplicationId() {
        return this.applicationId;
    }

    public void setApplicationId(@NotNull String applicationId) {
        this.applicationId = applicationId;
    }

    @NotNull
    public String getPublicKey() {
        return this.publicKey;
    }

    public void setPublicKey(@NotNull String publicKey) {
        this.publicKey = publicKey;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @NotNull
    public Long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(@NotNull Long timeout) {
        this.timeout = timeout;
    }

    @NotNull
    public Set<String> getUrlPatterns() {
        return this.urlPatterns;
    }

    public void setUrlPatterns(@NotNull Set<String> urlPatterns) {
        this.urlPatterns = ImmutableSet.copyOf(urlPatterns);
    }

    @NotNull
    public Set<String> getIpPatterns() {
        return this.ipPatterns;
    }

    public void setIpPatterns(@NotNull Set<String> ipPatterns) {
        this.ipPatterns = ImmutableSet.copyOf(ipPatterns);
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.applicationId).append((Object)this.publicKey).append((Object)this.name).append((Object)this.timeout).toHashCode();
    }

    public boolean equals(Object o) {
        if (!(o instanceof BambooTrustedApplicationImpl)) {
            return false;
        }
        BambooTrustedApplicationImpl rhs = (BambooTrustedApplicationImpl)((Object)o);
        return new EqualsBuilder().append((Object)this.applicationId, (Object)rhs.applicationId).append((Object)this.publicKey, (Object)rhs.publicKey).append((Object)this.name, (Object)rhs.name).append((Object)this.timeout, (Object)rhs.timeout).isEquals();
    }

    public int compareTo(BambooTrustedApplication o) {
        return new CompareToBuilder().append((Object)this.applicationId, (Object)o.getApplicationId()).append((Object)this.publicKey, (Object)o.getPublicKey()).append((Object)this.name, (Object)o.getName()).append((Object)this.timeout, (Object)o.getTimeout()).toComparison();
    }
}

