/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.security.trustedapplications;

import com.atlassian.bamboo.core.BambooObject;
import com.atlassian.bamboo.security.trustedapplications.BambooCurrentApplication;
import com.atlassian.bamboo.security.trustedapplications.BambooTrustedApplication;
import com.atlassian.bamboo.security.trustedapplications.BambooTrustedApplicationDao;
import com.atlassian.bamboo.security.trustedapplications.BambooTrustedApplicationImpl;
import com.atlassian.bamboo.security.trustedapplications.BambooTrustedApplicationsManager;
import com.atlassian.bamboo.security.trustedapplications.KeyUtils;
import com.atlassian.security.auth.trustedapps.Application;
import com.atlassian.security.auth.trustedapps.ApplicationRetriever;
import com.atlassian.security.auth.trustedapps.CurrentApplication;
import com.atlassian.security.auth.trustedapps.DefaultCurrentApplication;
import com.atlassian.security.auth.trustedapps.DefaultTrustedApplication;
import com.atlassian.security.auth.trustedapps.EncryptionProvider;
import com.atlassian.security.auth.trustedapps.RequestConditions;
import com.atlassian.security.auth.trustedapps.TrustedApplication;
import com.atlassian.security.auth.trustedapps.TrustedApplicationUtils;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.security.Key;
import java.security.KeyPair;
import java.security.PublicKey;
import java.util.Collection;
import java.util.Set;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BambooTrustedApplicationsManagerImpl
implements BambooTrustedApplicationsManager {
    private static final Logger log = Logger.getLogger(BambooTrustedApplicationsManagerImpl.class);
    private final EncryptionProvider encryptionProvider;
    private final BambooTrustedApplicationDao trustedAppsDao;

    public BambooTrustedApplicationsManagerImpl(EncryptionProvider encryptionProvider, BambooTrustedApplicationDao trustedAppsDao) {
        this.encryptionProvider = encryptionProvider;
        this.trustedAppsDao = trustedAppsDao;
    }

    @Nullable
    public TrustedApplication getTrustedApplication(String applicationId) {
        BambooTrustedApplication bambooTrustedApp = this.trustedAppsDao.findByApplicationId(applicationId);
        if (bambooTrustedApp == null) {
            log.info((Object)String.format("Unable to find application with id %s", applicationId));
            return null;
        }
        return this.toTrustedApp(bambooTrustedApp, this.determineCertTimeout(bambooTrustedApp, this.getCurrentApplicationNotNull()));
    }

    public CurrentApplication getCurrentApplication() {
        BambooCurrentApplication currentApp = this.getCurrentApplicationNotNull();
        KeyPair keyPair = currentApp.getKeyPair();
        return new DefaultCurrentApplication(keyPair.getPublic(), keyPair.getPrivate(), currentApp.getApplicationId());
    }

    @NotNull
    private BambooCurrentApplication getCurrentApplicationNotNull() {
        BambooCurrentApplication currentApplication = this.trustedAppsDao.getCurrentApplication();
        Preconditions.checkState((currentApplication != null ? 1 : 0) != 0, (Object)"Trusted Apps not initialised, please restart your server");
        assert (currentApplication != null);
        return currentApplication;
    }

    @Override
    public void save(BambooCurrentApplication currentApplication) {
        this.trustedAppsDao.save(currentApplication);
    }

    public Application getApplicationCertificate(String baseUrl) throws ApplicationRetriever.RetrievalException {
        return this.encryptionProvider.getApplicationCertificate(baseUrl);
    }

    public TrustedApplication addTrustedApplication(Application app, RequestConditions conditions) {
        BambooTrustedApplication existing = this.trustedAppsDao.findByApplicationId(app.getID());
        if (existing == null) {
            DefaultTrustedApplication trustedApp = new DefaultTrustedApplication(this.encryptionProvider, app.getPublicKey(), app.getID(), conditions);
            BambooTrustedApplicationImpl bambooTrustedApplication = new BambooTrustedApplicationImpl(app.getID(), KeyUtils.encode((Key)app.getPublicKey()), trustedApp.getName(), conditions.getCertificateTimeout(), (Set<String>)ImmutableSet.copyOf((Iterable)conditions.getURLPatterns()), (Set<String>)ImmutableSet.copyOf((Iterable)conditions.getIPPatterns()));
            this.trustedAppsDao.save((BambooObject)bambooTrustedApplication);
        } else {
            BambooTrustedApplicationImpl bambooTrustedApplication = (BambooTrustedApplicationImpl)existing;
            bambooTrustedApplication.setTimeout(conditions.getCertificateTimeout());
            bambooTrustedApplication.setIpPatterns((Set<String>)ImmutableSet.copyOf((Iterable)conditions.getIPPatterns()));
            bambooTrustedApplication.setUrlPatterns((Set<String>)ImmutableSet.copyOf((Iterable)conditions.getURLPatterns()));
            this.trustedAppsDao.save((BambooObject)bambooTrustedApplication);
        }
        BambooTrustedApplication bambooTrustedApp = this.trustedAppsDao.findByApplicationId(app.getID());
        return this.toTrustedApp(bambooTrustedApp, this.determineCertTimeout(bambooTrustedApp, this.getCurrentApplicationNotNull()));
    }

    public boolean deleteApplication(String applicationId) {
        BambooTrustedApplication trustedApp = this.trustedAppsDao.findByApplicationId(applicationId);
        try {
            this.trustedAppsDao.delete((BambooObject)trustedApp);
            return true;
        }
        catch (Exception e) {
            log.warn((Object)("Cannot delete application with id: " + applicationId), (Throwable)e);
            return false;
        }
    }

    public Iterable<TrustedApplication> getTrustedApplications() {
        BambooCurrentApplication currentApp = this.trustedAppsDao.getCurrentApplication();
        ImmutableList.Builder trustedApps = ImmutableList.builder();
        Collection bambooTrustedApps = this.trustedAppsDao.findAll(BambooTrustedApplicationImpl.class);
        for (BambooTrustedApplication bambooTrustedApp : bambooTrustedApps) {
            trustedApps.add((Object)this.toTrustedApp(bambooTrustedApp, this.determineCertTimeout(bambooTrustedApp, currentApp)));
        }
        return trustedApps.build();
    }

    private long determineCertTimeout(@NotNull BambooTrustedApplication trustedApp, @Nullable BambooCurrentApplication currentApp) {
        boolean isItMe = currentApp != null && trustedApp.getApplicationId().equals(currentApp.getApplicationId());
        return isItMe ? TrustedApplicationUtils.getLoopbackCallTimeout() : trustedApp.getTimeout();
    }

    private TrustedApplication toTrustedApp(BambooTrustedApplication trustedApp, long timeout) {
        PublicKey publicKey = KeyUtils.decodePublicKey((EncryptionProvider)this.encryptionProvider, (String)trustedApp.getPublicKey());
        RequestConditions.RulesBuilder conditionsBuilder = RequestConditions.builder().setCertificateTimeout(timeout);
        for (String ipPattern : trustedApp.getIpPatterns()) {
            conditionsBuilder.addIPPattern(new String[]{ipPattern});
        }
        for (String urlPattern : trustedApp.getUrlPatterns()) {
            conditionsBuilder.addURLPattern(new String[]{urlPattern});
        }
        return new DefaultTrustedApplication(this.encryptionProvider, publicKey, trustedApp.getApplicationId(), conditionsBuilder.build());
    }
}

