/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.serialization;

import com.atlassian.bamboo.configuration.SerializationSecurityMethod;
import com.atlassian.bamboo.plugin.BambooPluginUtils;
import com.atlassian.bamboo.security.SerializableClassWhitelistProvider;
import com.atlassian.bamboo.security.SystemSerializableClassWhitelistProvider;
import com.atlassian.bamboo.serialization.BlacklistCache;
import com.atlassian.bamboo.serialization.SerializationSecurityManager;
import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.event.PluginEventListener;
import com.atlassian.plugin.event.PluginEventManager;
import com.atlassian.plugin.event.events.PluginDisabledEvent;
import com.atlassian.plugin.event.events.PluginEnabledEvent;
import com.atlassian.plugin.event.events.PluginModuleDisabledEvent;
import com.atlassian.plugin.event.events.PluginModuleEnabledEvent;
import com.atlassian.plugin.event.events.PluginUninstalledEvent;
import com.atlassian.plugin.event.events.PluginUpgradedEvent;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractSerializationSecurityManager
implements SerializationSecurityManager {
    private static final Logger log = Logger.getLogger(AbstractSerializationSecurityManager.class);
    private final PluginAccessor pluginAccessor;
    private final PluginEventManager pluginEventManager;
    private final SystemSerializableClassWhitelistProvider systemSerializableClassWhitelistProvider;
    protected volatile Optional<Set<String>> completeClassNameWhitelist = Optional.absent();
    protected volatile List<String> pluginProvidedClassNameWhitelist = Collections.emptyList();
    private volatile Set<String> systemClassNameWhitelist = Collections.emptySet();
    private final Lock masterClassWhitelistLock = new ReentrantLock();
    private final Lock pluginProvidedClassWhitelistLock = new ReentrantLock();
    private final AtomicInteger recalculateWhitelistFromPluginRequestCount = new AtomicInteger(0);

    protected AbstractSerializationSecurityManager(PluginAccessor pluginAccessor, PluginEventManager pluginEventManager, SystemSerializableClassWhitelistProvider systemSerializableClassWhitelistProvider) {
        this.pluginAccessor = pluginAccessor;
        this.pluginEventManager = pluginEventManager;
        this.systemSerializableClassWhitelistProvider = systemSerializableClassWhitelistProvider;
    }

    @Override
    public Set<String> getClassNameWhitelist() {
        Optional<Set<String>> whitelist = this.completeClassNameWhitelist;
        Preconditions.checkState((boolean)whitelist.isPresent(), (Object)"Class name whitelist not initialized, service is starting or shutting down");
        return (Set)whitelist.get();
    }

    @Override
    public boolean isBlacklisted(@NotNull Class<?> type, @NotNull SerializationSecurityMethod method) {
        return BlacklistCache.isBlacklisted(type, method);
    }

    @PostConstruct
    public void registerPluginEventListeners() throws Exception {
        this.systemClassNameWhitelist = ImmutableSet.copyOf(this.systemSerializableClassWhitelistProvider.getWhitelistedClasses());
        this.recalculateWhitelistFromPlugins();
        this.pluginEventManager.register((Object)this);
    }

    @PreDestroy
    public void unregisterPluginEventListeners() throws Exception {
        this.pluginEventManager.unregister((Object)this);
        this.completeClassNameWhitelist = Optional.absent();
    }

    @PluginEventListener
    public void pluginUninstalled(PluginUninstalledEvent pluginUninstalledEvent) {
        this.pluginEvent(pluginUninstalledEvent.getPlugin());
    }

    @PluginEventListener
    public void pluginUpgraded(PluginUpgradedEvent pluginUpgradedEvent) {
        this.pluginEvent(pluginUpgradedEvent.getPlugin());
    }

    @PluginEventListener
    public void pluginEnabled(PluginEnabledEvent pluginEnabledEvent) {
        this.pluginEvent(pluginEnabledEvent.getPlugin());
    }

    @PluginEventListener
    public void pluginDisabled(PluginDisabledEvent pluginDisabledEvent) {
        this.pluginEvent(pluginDisabledEvent.getPlugin());
    }

    @PluginEventListener
    public void pluginModuleEnabled(PluginModuleEnabledEvent pluginModuleEnabledEvent) {
        this.pluginModuleEvent(pluginModuleEnabledEvent.getModule());
    }

    @PluginEventListener
    public void pluginModuleDisabled(PluginModuleDisabledEvent pluginModuleDisabledEvent) {
        this.pluginModuleEvent(pluginModuleDisabledEvent.getModule());
    }

    protected final void recalculateMasterClassWhitelist() {
        this.masterClassWhitelistLock.lock();
        try {
            log.debug((Object)"Recalculating master whitelist");
            this.completeClassNameWhitelist = Optional.of(this.buildCompleteClassNameWhitelist());
        }
        finally {
            this.masterClassWhitelistLock.unlock();
        }
    }

    private Set<String> buildCompleteClassNameWhitelist() {
        ImmutableSet.Builder whitelistBuilder = ImmutableSet.builder().addAll(this.systemClassNameWhitelist).addAll(this.pluginProvidedClassNameWhitelist);
        this.addWhitelistedClassNames((ImmutableSet.Builder<String>)whitelistBuilder);
        return whitelistBuilder.build();
    }

    protected abstract void addWhitelistedClassNames(@NotNull ImmutableSet.Builder<String> var1);

    private void pluginEvent(Plugin plugin) {
        List whitelistProviders = plugin.getModuleDescriptorsByModuleClass(SerializableClassWhitelistProvider.class);
        if (!whitelistProviders.isEmpty()) {
            this.recalculateWhitelistFromPlugins();
        } else if (log.isTraceEnabled()) {
            log.trace((Object)String.format("Ignoring plugin %s event - this provides no SerializableClassWhitelistProvider", plugin.getKey()));
        }
    }

    private void pluginModuleEvent(ModuleDescriptor<?> moduleDescriptor) {
        if (SerializableClassWhitelistProvider.class.equals((Object)moduleDescriptor.getModuleClass())) {
            this.recalculateWhitelistFromPlugins();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void recalculateWhitelistFromPlugins() {
        boolean doRecalculate;
        AtomicInteger atomicInteger = this.recalculateWhitelistFromPluginRequestCount;
        synchronized (atomicInteger) {
            doRecalculate = this.recalculateWhitelistFromPluginRequestCount.compareAndSet(0, 1) || this.recalculateWhitelistFromPluginRequestCount.compareAndSet(1, 2);
        }
        if (doRecalculate) {
            this.pluginProvidedClassWhitelistLock.lock();
            try {
                this.pluginProvidedClassNameWhitelist = this.buildWhitelistFromPlugins();
                this.recalculateMasterClassWhitelist();
            }
            finally {
                this.recalculateWhitelistFromPluginRequestCount.decrementAndGet();
                this.pluginProvidedClassWhitelistLock.unlock();
            }
        }
    }

    private List<String> buildWhitelistFromPlugins() {
        final LinkedList<String> whitelist = new LinkedList<String>();
        List whitelistProviders = this.pluginAccessor.getEnabledModulesByClass(SerializableClassWhitelistProvider.class);
        log.debug((Object)String.format("Found %d whitelist providers", whitelistProviders.size()));
        for (final SerializableClassWhitelistProvider whitelistProvider : whitelistProviders) {
            BambooPluginUtils.callUnsafeCode(new BambooPluginUtils.Runnable(String.format("Unable to get whitelist from provider %s", whitelistProvider.getClass().getName())){

                @Override
                public void run() {
                    Iterables.addAll((Collection)whitelist, (Iterable)whitelistProvider.getWhitelistedClasses());
                }
            });
        }
        return whitelist;
    }
}

