/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.serialization;

import com.atlassian.bamboo.security.SerializableClassWhitelistProvider;
import com.atlassian.bamboo.serialization.FileMonitor;
import com.atlassian.bamboo.serialization.event.BambooHomeDirectoryClassWhitelistChanged;
import com.atlassian.bamboo.setup.BootstrapManager;
import com.atlassian.bamboo.utils.fage.Result;
import com.atlassian.event.api.EventPublisher;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.apache.commons.io.FileUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Component;

@Component
public class BambooHomeDirectoryClassWhitelistProvider
implements SerializableClassWhitelistProvider {
    private static final Logger log = Logger.getLogger(BambooHomeDirectoryClassWhitelistProvider.class);
    @VisibleForTesting
    public static final String CLASS_WHITELIST_FILE_NAME = "serialization-whitelist.list";
    private final BootstrapManager bootstrapManager;
    private final EventPublisher eventPublisher;
    private final FileMonitor fileMonitor;
    private volatile Collection<String> homeDirectoryClassWhitelist = Collections.emptySet();

    @Inject
    public BambooHomeDirectoryClassWhitelistProvider(@NotNull BootstrapManager bootstrapManager, @NotNull EventPublisher eventPublisher) {
        this.bootstrapManager = bootstrapManager;
        this.eventPublisher = eventPublisher;
        try {
            final Path configDirectory = Paths.get(this.bootstrapManager.getConfigDirectory(), new String[0]);
            this.fileMonitor = new FileMonitor(configDirectory){

                @Override
                public void react(WatchEvent<Path> event, Path filename) {
                    WatchEvent.Kind<Path> kind = event.kind();
                    log.debug((Object)(kind + " " + filename));
                    if (!filename.getFileName().toString().equals(BambooHomeDirectoryClassWhitelistProvider.CLASS_WHITELIST_FILE_NAME)) {
                        return;
                    }
                    Path affectedPath = configDirectory.resolve(filename);
                    if (kind == StandardWatchEventKinds.ENTRY_CREATE) {
                        log.debug((Object)String.format("Whitelist file %s created - reading", BambooHomeDirectoryClassWhitelistProvider.CLASS_WHITELIST_FILE_NAME));
                        BambooHomeDirectoryClassWhitelistProvider.this.handleWhitelistFileCreatedOrModified(affectedPath.toFile());
                    } else if (kind == StandardWatchEventKinds.ENTRY_MODIFY) {
                        log.debug((Object)String.format("Whitelist file %s modified - rereading", BambooHomeDirectoryClassWhitelistProvider.CLASS_WHITELIST_FILE_NAME));
                        BambooHomeDirectoryClassWhitelistProvider.this.handleWhitelistFileCreatedOrModified(affectedPath.toFile());
                    } else if (kind == StandardWatchEventKinds.ENTRY_DELETE) {
                        log.debug((Object)String.format("Whitelist file %s deleted - clearing memoized list", BambooHomeDirectoryClassWhitelistProvider.CLASS_WHITELIST_FILE_NAME));
                        BambooHomeDirectoryClassWhitelistProvider.this.handleWhitelistFileDeleted();
                    }
                }
            };
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    @NotNull
    public Iterable<String> getWhitelistedClasses() {
        return this.homeDirectoryClassWhitelist;
    }

    @PostConstruct
    @VisibleForTesting
    void initializeWhitelistFileMonitoring() {
        Result<IOException, List<String>> whitelistFromFileResult = this.getWhitelistFromFile(new File(this.bootstrapManager.getConfigDirectory(), CLASS_WHITELIST_FILE_NAME));
        if (!whitelistFromFileResult.hasException()) {
            this.homeDirectoryClassWhitelist = ImmutableList.copyOf((Collection)((Collection)whitelistFromFileResult.getResult()));
        }
        this.fileMonitor.start();
    }

    @PreDestroy
    @VisibleForTesting
    void stopWhitelistFileMonitoring() throws IOException {
        this.fileMonitor.close();
    }

    private void handleWhitelistFileCreatedOrModified(@NotNull File file) {
        if (file.isFile() && file.canRead()) {
            try {
                this.homeDirectoryClassWhitelist = ImmutableList.copyOf((Collection)((Collection)this.getWhitelistFromFile(file).getResultThrowException()));
                this.eventPublisher.publish((Object)new BambooHomeDirectoryClassWhitelistChanged(this.homeDirectoryClassWhitelist));
            }
            catch (IOException e) {
                log.warn((Object)String.format("Unable to read whitelist from %s", file.getAbsolutePath()), (Throwable)e);
            }
        } else {
            log.debug((Object)String.format("Whitelist file %s doesn't exist or is not readable", file.getAbsolutePath()));
        }
    }

    private void handleWhitelistFileDeleted() {
        this.homeDirectoryClassWhitelist = Collections.emptyList();
        this.eventPublisher.publish((Object)new BambooHomeDirectoryClassWhitelistChanged(this.homeDirectoryClassWhitelist));
    }

    private Result<IOException, List<String>> getWhitelistFromFile(@NotNull File file) {
        try {
            return Result.result((Object)FileUtils.readLines((File)file));
        }
        catch (IOException e) {
            return Result.exception((Throwable)e);
        }
    }
}

