/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.serialization;

import com.atlassian.bamboo.configuration.SerializationSecurityMethod;
import com.atlassian.bamboo.utils.BambooReflectionUtils;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.io.OutputStream;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Modifier;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.naming.Referenceable;
import javax.sql.RowSet;
import org.apache.commons.beanutils.BeanComparator;
import org.jetbrains.annotations.NotNull;
import org.springframework.jndi.JndiTemplate;
import org.springframework.remoting.support.RemoteInvocation;

class BlacklistCache {
    private static final Map<String, Boolean> BLACKLIST_CACHE = Collections.synchronizedMap(new HashMap());
    private static final Iterable<String> BLACKLISTED_PACKAGES = Lists.newArrayList((Object[])new String[]{"bsh", BeanComparator.class.getPackage().getName(), "com.sun.jndi.rmi", "java.rmi", "sun.rmi", "javax.management"});
    private static final Iterable<Class<?>> BLACKLISTED_PARENT_CLASSES = Lists.newArrayList((Object[])new Class[]{OutputStream.class, Referenceable.class, RowSet.class});
    private static final Set<String> BLACKLISTED_CLASS_NAMES = ImmutableSet.of((Object)"org.python.core.PyObject");
    private static final Set<Class<?>> BLACKLISTED_CLASSES = ImmutableSet.of(Class.class, JndiTemplate.class);
    private static final Set<String> BLACKLIST_EXCEPTIONS = ImmutableList.of(EnumMap.class, EnumSet.class, RemoteInvocation.class).stream().map(Class::getName).collect(Collectors.toSet());

    BlacklistCache() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isBlacklisted(@NotNull Class<?> possiblyAnArray, @NotNull SerializationSecurityMethod method) {
        Class simpleType = BambooReflectionUtils.getSimpleType(possiblyAnArray);
        if (simpleType.equals(Byte.TYPE)) {
            return possiblyAnArray.isArray() && method == SerializationSecurityMethod.STRICT_BLACKLIST;
        }
        if (Executable.class.isAssignableFrom(simpleType)) {
            return true;
        }
        if (BlacklistCache.isClassOnExceptionList(simpleType)) {
            return false;
        }
        String className = simpleType.getName();
        Boolean cachedResult = BLACKLIST_CACHE.get(className);
        if (cachedResult != null) {
            return cachedResult;
        }
        String string = className.intern();
        synchronized (string) {
            Boolean cachedResult2 = BLACKLIST_CACHE.get(className);
            if (cachedResult2 != null) {
                return cachedResult2;
            }
            boolean blacklisted = BlacklistCache.isBlacklistedNoCache(simpleType);
            BLACKLIST_CACHE.put(className, blacklisted);
            return blacklisted;
        }
    }

    static boolean isBlacklistedNoCache(Class<?> clazz) {
        for (String string : BLACKLISTED_PACKAGES) {
            if (!BlacklistCache.isClassFromPackage(clazz, string)) continue;
            return true;
        }
        for (Class clazz2 : BLACKLISTED_PARENT_CLASSES) {
            if (!clazz2.isAssignableFrom(clazz)) continue;
            return true;
        }
        if (BLACKLISTED_CLASS_NAMES.contains(clazz.getName())) {
            return true;
        }
        if (clazz.getName().contains("MethodInvokeTypeProvider")) {
            return true;
        }
        boolean noCustomDeserialisation = !BambooReflectionUtils.hasCustomDeserialisation(clazz);
        List list = BambooReflectionUtils.getAllDeclaredFields(clazz);
        for (Field field : list) {
            boolean isBlacklistedField;
            if (noCustomDeserialisation && BlacklistCache.isNotSerialised(field) || !(isBlacklistedField = BLACKLISTED_CLASSES.contains(BambooReflectionUtils.getSimpleType(field.getType()))) || BlacklistCache.isOwnerOnExceptionList(field)) continue;
            return true;
        }
        return false;
    }

    private static boolean isClassFromPackage(Class<?> clazz, String rootPackage) {
        String classPackage = clazz.getPackage().getName();
        return classPackage.equals(rootPackage) || classPackage.startsWith(rootPackage + ".");
    }

    private static boolean isOwnerOnExceptionList(Member field) {
        return BlacklistCache.isClassOnExceptionList(field.getDeclaringClass());
    }

    private static boolean isClassOnExceptionList(Class<?> clazz) {
        return BLACKLIST_EXCEPTIONS.contains(clazz.getName());
    }

    private static boolean isNotSerialised(Field field) {
        int modifiers = field.getModifiers();
        return Modifier.isStatic(modifiers) || Modifier.isTransient(modifiers);
    }
}

