/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.serialization;

import com.google.common.base.Throwables;
import java.io.Closeable;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

abstract class FileMonitor
implements Closeable {
    private static final Logger log = Logger.getLogger(FileMonitor.class);
    private final Thread fileMonitoringThread;
    private final WatchService watchService = FileSystems.getDefault().newWatchService();

    FileMonitor(Path configDirectory) throws IOException {
        this.fileMonitoringThread = new Thread(this.newDirWatcher(this.watchService, configDirectory), this.getClass().getSimpleName());
    }

    @NotNull
    private Runnable newDirWatcher(WatchService watcher, Path configDirectory) {
        return () -> {
            WatchKey key;
            try {
                configDirectory.register(watcher, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_DELETE, StandardWatchEventKinds.ENTRY_MODIFY);
            }
            catch (IOException e) {
                throw Throwables.propagate((Throwable)e);
            }
            do {
                try {
                    key = watcher.take();
                }
                catch (InterruptedException ignored) {
                    log.info((Object)("Thread interrupted, ceasing monitoring of " + configDirectory));
                    return;
                }
                for (WatchEvent<Path> watchEvent : key.pollEvents()) {
                    WatchEvent.Kind<?> kind = watchEvent.kind();
                    if (kind == StandardWatchEventKinds.OVERFLOW) continue;
                    WatchEvent<Path> ev = watchEvent;
                    Path filename = (Path)ev.context();
                    this.react(ev, filename);
                }
            } while (key.reset());
            log.error((Object)(configDirectory + " deleted"));
        };
    }

    public void start() {
        this.fileMonitoringThread.start();
    }

    @Override
    public void close() throws IOException {
        this.fileMonitoringThread.interrupt();
        this.watchService.close();
    }

    public abstract void react(WatchEvent<Path> var1, Path var2);
}

