/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.serialization;

import com.atlassian.bamboo.security.SystemSerializableClassWhitelistProvider;
import com.atlassian.bamboo.serialization.AbstractSerializationSecurityManager;
import com.atlassian.bamboo.serialization.BambooHomeDirectoryClassWhitelistProvider;
import com.atlassian.bamboo.serialization.event.BambooHomeDirectoryClassWhitelistChanged;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.event.PluginEventManager;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Collections;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class SerializationSecurityManagerImpl
extends AbstractSerializationSecurityManager {
    private static final Logger log = Logger.getLogger(SerializationSecurityManagerImpl.class);
    @VisibleForTesting
    static final String CLASS_WHITELIST_FILE_NAME = "serialization-whitelist.list";
    private final EventPublisher eventPublisher;
    private final BambooHomeDirectoryClassWhitelistProvider bambooHomeDirectoryClassWhitelistProvider;
    private volatile Collection<String> homeDirectoryClassWhitelist = Collections.emptySet();

    @Inject
    public SerializationSecurityManagerImpl(@NotNull EventPublisher eventPublisher, @NotNull PluginAccessor pluginAccessor, @NotNull PluginEventManager pluginEventManager, @NotNull BambooHomeDirectoryClassWhitelistProvider bambooHomeDirectoryClassWhitelistProvider, @NotNull SystemSerializableClassWhitelistProvider systemSerializableClassWhitelistProvider) {
        super(pluginAccessor, pluginEventManager, systemSerializableClassWhitelistProvider);
        this.eventPublisher = eventPublisher;
        this.bambooHomeDirectoryClassWhitelistProvider = bambooHomeDirectoryClassWhitelistProvider;
    }

    @PostConstruct
    @VisibleForTesting
    void postConstruct() throws Exception {
        this.homeDirectoryClassWhitelist = ImmutableList.copyOf(this.bambooHomeDirectoryClassWhitelistProvider.getWhitelistedClasses());
        this.recalculateMasterClassWhitelist();
        this.eventPublisher.register((Object)this);
    }

    @PreDestroy
    @VisibleForTesting
    void preDestroy() throws Exception {
        this.eventPublisher.unregister((Object)this);
    }

    @EventListener
    public void onSerializableClassWhitelistChanged(@NotNull BambooHomeDirectoryClassWhitelistChanged event) {
        this.homeDirectoryClassWhitelist = event.getWhitelist();
        this.recalculateMasterClassWhitelist();
    }

    @Override
    protected void addWhitelistedClassNames(@NotNull ImmutableSet.Builder<String> whitelistBuilder) {
        whitelistBuilder.addAll(this.homeDirectoryClassWhitelist);
    }
}

