/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.serialization.xstream;

import com.atlassian.bamboo.serialization.xstream.AbstractXStreamConverterAdapter;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.mapper.Mapper;
import org.apache.log4j.Logger;
import org.hibernate.Hibernate;
import org.hibernate.collection.internal.PersistentBag;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractHibernateCollectionConverter
extends AbstractXStreamConverterAdapter {
    private static final Logger log = Logger.getLogger(AbstractHibernateCollectionConverter.class);
    private static final Package HIBERNATE_COLLECTIONS_PACKAGE = PersistentBag.class.getPackage();

    protected AbstractHibernateCollectionConverter(Mapper mapper, Class<? extends Converter> converterClass) {
        super(mapper, converterClass);
    }

    public boolean canConvert(Class type) {
        return type != null && this.isInHibernateCollectionPackage(type) && this.isSupportedType(type);
    }

    @Override
    public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
        if (Hibernate.isInitialized((Object)source)) {
            super.marshal(source, writer, context);
        } else {
            log.debug((Object)"A Hibernate collection was not initialised and will not be serialised");
        }
    }

    protected abstract boolean isSupportedType(@NotNull Class var1);

    private boolean isInHibernateCollectionPackage(@NotNull Class type) {
        return HIBERNATE_COLLECTIONS_PACKAGE.equals(type.getPackage());
    }
}

