/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.serialization.xstream;

import com.atlassian.bamboo.persister.xstream.XStreamUtils;
import com.atlassian.bamboo.v2.build.BuildContext;
import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.converters.reflection.ReflectionConverter;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import java.lang.reflect.Field;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class BuildContextXStreamConverter
implements Converter {
    private static final Logger log = Logger.getLogger(BuildContextXStreamConverter.class);
    private final Converter converter;

    public BuildContextXStreamConverter(@NotNull XStream xStream) {
        this.converter = new ReflectionConverter(xStream.getMapper(), xStream.getReflectionProvider());
    }

    public boolean canConvert(Class type) {
        return BuildContext.class.isAssignableFrom(type);
    }

    public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
        try {
            this.converter.marshal(source, writer, context);
        }
        catch (RuntimeException e) {
            this.tryDumpingContext(writer);
            throw e;
        }
    }

    private void tryDumpingContext(HierarchicalStreamWriter writer) {
        log.error((Object)("Error context: " + XStreamUtils.getPath(writer)));
    }

    private void dumpObject(Object source) {
        this.dumpFields(new HashSet<Object>(), "", source, source.getClass().getDeclaredFields());
    }

    private void dumpFields(Set<Object> alreadyDumped, String indent, Object source, Field[] fields) {
        indent = indent + "   ";
        for (Field field : fields) {
            field.setAccessible(true);
            try {
                Object fieldValue = field.get(source);
                if (fieldValue == null || alreadyDumped.contains(fieldValue)) continue;
                alreadyDumped.add(fieldValue);
                if (fieldValue instanceof Object[]) {
                    Object[] array;
                    for (Object fieldArrValue : array = (Object[])fieldValue) {
                        if (fieldArrValue == null) continue;
                        this.dumpFields(alreadyDumped, indent, fieldArrValue, fieldArrValue.getClass().getDeclaredFields());
                    }
                    continue;
                }
                Class<?> fieldRuntimeClass = fieldValue.getClass();
                log.info((Object)(indent + field.getName() + " :  " + fieldRuntimeClass));
                this.dumpFields(alreadyDumped, indent, fieldValue, fieldRuntimeClass.getDeclaredFields());
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
    }

    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        return this.converter.unmarshal(reader, context);
    }
}

