/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.serialization.xstream;

import com.atlassian.bamboo.build.BuildDefinition;
import com.atlassian.bamboo.build.DefaultBuildDefinition;
import com.atlassian.bamboo.build.PartialBuildDefinition;
import com.atlassian.bamboo.fieldvalue.BuildDefinitionConverter;
import com.atlassian.bamboo.serialization.xstream.ConfigurationToXStream;
import com.atlassian.bamboo.serialization.xstream.XStreamToConfiguration;
import com.atlassian.bamboo.spring.ComponentAccessor;
import com.atlassian.bamboo.utils.ConfigUtils;
import com.atlassian.bamboo.utils.xstream.converters.ConverterFactory;
import com.google.common.base.Supplier;
import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.commons.configuration.XMLConfiguration;
import org.jetbrains.annotations.NotNull;

public class BuildDefinitionXStreamConverter
implements Converter {
    private final Supplier<BuildDefinitionConverter> buildDefinitionConverter = ComponentAccessor.newLazyComponentReference("buildDefinitionConverter");

    public boolean canConvert(Class type) {
        return BuildDefinition.class.isAssignableFrom(type);
    }

    public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
        BuildDefinition buildDefinition = (BuildDefinition)source;
        XMLConfiguration config = ((BuildDefinitionConverter)this.buildDefinitionConverter.get()).fromObject((PartialBuildDefinition)buildDefinition);
        ConfigurationToXStream.convert((HierarchicalConfiguration)config, writer);
    }

    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        XMLConfiguration configuration = ConfigUtils.newConfiguration();
        this.writeToConfig(reader, (HierarchicalConfiguration)configuration);
        DefaultBuildDefinition answer = new DefaultBuildDefinition(true);
        ((BuildDefinitionConverter)this.buildDefinitionConverter.get()).copyConfigurationToDefinition((HierarchicalConfiguration)configuration, answer);
        return answer;
    }

    private void writeToConfig(HierarchicalStreamReader reader, HierarchicalConfiguration configuration) {
        reader.moveDown();
        XStreamToConfiguration.convert(reader, configuration);
        reader.moveUp();
    }

    public static class Factory
    implements ConverterFactory {
        @NotNull
        public Converter createConverter(@NotNull XStream xStream) {
            return new BuildDefinitionXStreamConverter();
        }
    }
}

