/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.serialization.xstream;

import com.thoughtworks.xstream.mapper.CannotResolveClassException;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CannotResolvePluginClassException
extends CannotResolveClassException {
    private final String className;
    private final String pluginKey;
    private final String pluginVersion;

    public static String formatMessage(@Nullable String reason, @NotNull String className, @NotNull String pluginKey, @Nullable String pluginVersion) {
        StringBuilder builder = new StringBuilder("Could not resolve class '").append(className).append("' from plugin '").append(pluginKey).append("'");
        if (StringUtils.isNotEmpty((CharSequence)pluginVersion)) {
            builder.append(" with version '").append(pluginVersion).append("'");
        }
        if (StringUtils.isNotEmpty((CharSequence)reason)) {
            builder.append(": ").append(reason);
        }
        return builder.toString();
    }

    public CannotResolvePluginClassException(@NotNull String className, @NotNull String pluginKey, @Nullable String pluginVersion) {
        this(null, className, pluginKey, pluginVersion);
    }

    public CannotResolvePluginClassException(@Nullable String reason, @NotNull String className, @NotNull String pluginKey, @Nullable String pluginVersion) {
        super(CannotResolvePluginClassException.formatMessage(reason, className, pluginKey, pluginVersion));
        this.className = className;
        this.pluginKey = pluginKey;
        this.pluginVersion = pluginVersion;
    }

    public String getClassName() {
        return this.className;
    }

    public String getPluginKey() {
        return this.pluginKey;
    }

    public String getPluginVersion() {
        return this.pluginVersion;
    }
}

