/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.serialization.xstream;

import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import java.util.List;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.commons.configuration.tree.ConfigurationNode;

public final class ConfigurationToXStream {
    private final HierarchicalConfiguration from;

    public ConfigurationToXStream(HierarchicalConfiguration from) {
        this.from = from;
    }

    public void writeTo(HierarchicalStreamWriter writer) {
        ConfigurationToXStream.convert(this.from, writer);
    }

    public static void convert(HierarchicalConfiguration from, HierarchicalStreamWriter to) {
        ConfigurationToXStream.convertNode(from.getRootNode(), to);
    }

    public static void convertNode(ConfigurationNode from, HierarchicalStreamWriter to) {
        to.startNode(from.getName() != null ? from.getName() : "null");
        ConfigurationToXStream.setNullAttribute(from, to);
        for (ConfigurationNode attribute : ConfigurationToXStream.getAttributes(from)) {
            to.addAttribute(attribute.getName(), attribute.getValue().toString());
        }
        if (from.getValue() != null) {
            to.setValue(from.getValue().toString());
        }
        for (ConfigurationNode childNode : ConfigurationToXStream.getChildren(from)) {
            ConfigurationToXStream.convertNode(childNode, to);
        }
        to.endNode();
    }

    private static void setNullAttribute(ConfigurationNode from, HierarchicalStreamWriter to) {
        if (from.getName() == null) {
            to.addAttribute("node-name-null", Boolean.TRUE.toString());
        }
    }

    private static List<ConfigurationNode> getChildren(ConfigurationNode from) {
        return from.getChildren();
    }

    private static List<ConfigurationNode> getAttributes(ConfigurationNode from) {
        return from.getAttributes();
    }
}

