/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.serialization.xstream;

import com.atlassian.bamboo.serialization.PluginResolver;
import com.atlassian.bamboo.serialization.xstream.CannotResolvePluginClassException;
import com.atlassian.bamboo.serialization.xstream.IncompatiblePluginVersionException;
import com.atlassian.bamboo.serialization.xstream.OwningPluginNotInstalledException;
import com.atlassian.bamboo.utils.xstream.mappers.MapperFactory;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginAccessor;
import com.google.common.base.Strings;
import com.thoughtworks.xstream.mapper.Mapper;
import com.thoughtworks.xstream.mapper.MapperWrapper;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.context.annotation.Lazy;

public class PluginsAwareMapper
extends MapperWrapper {
    private static final String SHORT_PLUGIN_NAME_FORMAT = "%s-pluginKey-%s";
    private static final String PLUGIN_NAME_FORMAT = "%s-pluginKey-%s-pluginVersion-%s";
    private static final String PLUGIN_MARKER = "-pluginKey-";
    private static final String PLUGIN_KEY_TOKEN = "pluginKey-";
    private static final String PLUGIN_VERSION_TOKEN = "-pluginVersion-";
    private final PluginAccessor pluginAccessor;
    private final boolean enforceVersionCompatibility;

    @NotNull
    private static String formatPluginClassName(@NotNull String className, @NotNull String pluginKey, @Nullable String pluginVersion) {
        if (pluginVersion == null) {
            return String.format(SHORT_PLUGIN_NAME_FORMAT, className, pluginKey);
        }
        return String.format(PLUGIN_NAME_FORMAT, className, pluginKey, pluginVersion);
    }

    public PluginsAwareMapper(@NotNull Mapper wrapped, PluginAccessor pluginAccessor) {
        this(wrapped, pluginAccessor, false);
    }

    public PluginsAwareMapper(@NotNull Mapper wrapped, PluginAccessor pluginAccessor, boolean enforceVersionCompatibility) {
        super(wrapped);
        this.pluginAccessor = pluginAccessor;
        this.enforceVersionCompatibility = enforceVersionCompatibility;
    }

    public String serializedClass(Class type) {
        String pluginKey = PluginResolver.resolvePluginKey(type);
        if (pluginKey != null) {
            return PluginsAwareMapper.formatPluginClassName(super.serializedClass(type), pluginKey, this.resolveVersion(pluginKey));
        }
        return super.serializedClass(type);
    }

    public Class realClass(String elementName) {
        if (!elementName.contains(PLUGIN_MARKER)) {
            return super.realClass(elementName);
        }
        ClassFromPlugin classFromPlugin = PluginsAwareMapper.resolveClassFromPlugin(elementName);
        String pluginKey = classFromPlugin.pluginKey;
        Plugin plugin = this.pluginAccessor.getPlugin(pluginKey);
        if (plugin == null) {
            throw new OwningPluginNotInstalledException(classFromPlugin.className, pluginKey, classFromPlugin.pluginVersion);
        }
        return this.loadFromPlugin(classFromPlugin, plugin);
    }

    @Nullable
    private String resolveVersion(String pluginKey) {
        Plugin plugin = this.pluginAccessor.getPlugin(pluginKey);
        if (plugin == null) {
            return null;
        }
        return plugin.getPluginInformation().getVersion();
    }

    @NotNull
    private static ClassFromPlugin resolveClassFromPlugin(String elementName) {
        String pluginInfo = elementName.substring(elementName.indexOf(PLUGIN_MARKER) + 1, elementName.length());
        return new ClassFromPlugin(PluginsAwareMapper.readClassName(elementName), PluginsAwareMapper.readPluginKey(pluginInfo), PluginsAwareMapper.readPluginVersion(pluginInfo));
    }

    private static String readClassName(String elementName) {
        return elementName.substring(0, elementName.indexOf(PLUGIN_MARKER));
    }

    private static String readPluginKey(String pluginInfo) {
        int endOfPluginKey = pluginInfo.lastIndexOf(PLUGIN_VERSION_TOKEN);
        if (endOfPluginKey < 0) {
            endOfPluginKey = pluginInfo.length();
        }
        return pluginInfo.substring(PLUGIN_KEY_TOKEN.length(), endOfPluginKey);
    }

    private static String readPluginVersion(String pluginInfo) {
        return Strings.emptyToNull((String)StringUtils.substringAfterLast((String)pluginInfo, (String)PLUGIN_VERSION_TOKEN));
    }

    private Class<?> loadFromPlugin(@NotNull ClassFromPlugin classFromPlugin, @NotNull Plugin plugin) {
        this.checkVersionCompatibility(classFromPlugin, plugin);
        return this.doLoad(classFromPlugin, plugin);
    }

    private void checkVersionCompatibility(ClassFromPlugin classFromPlugin, Plugin plugin) {
        String requestedPluginVersion = classFromPlugin.pluginVersion;
        if (!this.enforceVersionCompatibility || requestedPluginVersion == null) {
            return;
        }
        String installedPluginVersion = plugin.getPluginInformation().getVersion();
        if (!requestedPluginVersion.equals(installedPluginVersion)) {
            throw new IncompatiblePluginVersionException(classFromPlugin.className, classFromPlugin.pluginKey, requestedPluginVersion, installedPluginVersion);
        }
    }

    private Class<?> doLoad(ClassFromPlugin classFromPlugin, Plugin plugin) {
        try {
            return plugin.loadClass(classFromPlugin.className, ((Object)((Object)this)).getClass());
        }
        catch (ClassNotFoundException e) {
            throw new CannotResolvePluginClassException("Plugin failed to load the class " + e, classFromPlugin.className, classFromPlugin.pluginKey, classFromPlugin.pluginVersion);
        }
    }

    private static final class ClassFromPlugin {
        private final String className;
        private final String pluginKey;
        private final String pluginVersion;

        private ClassFromPlugin(@NotNull String theClass, @NotNull String pluginKey, @Nullable String pluginVersion) {
            this.className = theClass;
            this.pluginKey = pluginKey;
            this.pluginVersion = pluginVersion;
        }
    }

    public static final class Factory
    implements MapperFactory {
        private final boolean enforceVersionCompatibility;
        @Lazy
        @Inject
        private PluginAccessor pluginAccessor;

        public Factory() {
            this(false);
        }

        public Factory(boolean enforceVersionCompatibility) {
            this.enforceVersionCompatibility = enforceVersionCompatibility;
        }

        @NotNull
        public MapperWrapper createMapper(@NotNull MapperWrapper wrappedMapper) {
            return new PluginsAwareMapper((Mapper)wrappedMapper, this.pluginAccessor, this.enforceVersionCompatibility);
        }
    }
}

