/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.serialization.xstream;

import com.atlassian.bamboo.utils.BambooInterners;
import com.atlassian.bamboo.utils.ConfigUtils;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.commons.configuration.XMLConfiguration;
import org.apache.commons.configuration.tree.ConfigurationNode;
import org.apache.commons.configuration.tree.DefaultConfigurationNode;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

public final class XStreamToConfiguration {
    static final String NULL_NODE_ATTRIBUTE = "node-name-null";
    static final String[] BUILT_IN_ATTRIBUTES = new String[]{"node-name-null"};
    static final List<String> BUILT_IN_ATTRIBUTES_LIST = Arrays.asList(BUILT_IN_ATTRIBUTES);
    static final Predicate<String> BUILT_IN_ATTRIBUTES_FILTER = new Predicate<String>(){

        public boolean apply(String input) {
            return !BUILT_IN_ATTRIBUTES_LIST.contains(input);
        }
    };

    @NotNull
    public static HierarchicalConfiguration convert(HierarchicalStreamReader from) {
        XMLConfiguration answer = ConfigUtils.newConfiguration();
        XStreamToConfiguration.convert(from, (HierarchicalConfiguration)answer);
        return answer;
    }

    public static void convert(@NotNull HierarchicalStreamReader from, @NotNull HierarchicalConfiguration to) {
        to.setRootNode(XStreamToConfiguration.createNode(from));
    }

    private static ConfigurationNode createNode(@NotNull HierarchicalStreamReader from) {
        DefaultConfigurationNode answer = new DefaultConfigurationNode(from.getNodeName());
        XStreamToConfiguration.checkNull(from, (ConfigurationNode)answer);
        XStreamToConfiguration.setAttributes(from, (ConfigurationNode)answer);
        XStreamToConfiguration.setValue(from, (ConfigurationNode)answer);
        XStreamToConfiguration.setChildren(from, (ConfigurationNode)answer);
        return answer;
    }

    private static void checkNull(HierarchicalStreamReader from, ConfigurationNode answer) {
        String nullAttr = from.getAttribute(NULL_NODE_ATTRIBUTE);
        if (Boolean.parseBoolean(nullAttr)) {
            answer.setName(null);
        }
    }

    private static void setAttributes(HierarchicalStreamReader from, ConfigurationNode answer) {
        for (String attributeName : XStreamToConfiguration.getAttributeNames(from)) {
            answer.addAttribute((ConfigurationNode)new DefaultConfigurationNode(BambooInterners.intern((String)attributeName.intern()), (Object)BambooInterners.intern((String)from.getAttribute(attributeName))));
        }
    }

    private static void setValue(HierarchicalStreamReader from, ConfigurationNode answer) {
        String value = from.getValue();
        if (StringUtils.isNotBlank((CharSequence)value)) {
            answer.setValue((Object)(value instanceof String ? BambooInterners.intern((String)value) : value));
        } else {
            answer.setValue((Object)"");
        }
    }

    private static void setChildren(HierarchicalStreamReader from, ConfigurationNode answer) {
        while (from.hasMoreChildren()) {
            from.moveDown();
            answer.addChild(XStreamToConfiguration.createNode(from));
            from.moveUp();
        }
    }

    private static Iterable<String> getAttributeNames(HierarchicalStreamReader from) {
        ArrayList allAttributes = Lists.newArrayList((Iterator)from.getAttributeNames());
        return Iterables.filter((Iterable)allAttributes, BUILT_IN_ATTRIBUTES_FILTER);
    }
}

