/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.server;

import com.atlassian.bamboo.security.SerializableClassWhitelistProvider;
import com.atlassian.bamboo.security.TrustedKey;
import com.atlassian.bamboo.security.TrustedKeyDTO;
import com.atlassian.bamboo.security.TrustedKeyService;
import com.atlassian.bamboo.server.ServerStateService;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.springframework.beans.factory.annotation.Qualifier;

public class ServerStateServiceImpl
implements ServerStateService {
    private final SerializableClassWhitelistProvider bambooHomeDirectoryClassWhitelistProvider;
    private final TrustedKeyService trustedKeyService;

    @Inject
    public ServerStateServiceImpl(@Qualifier(value="bambooHomeDirectoryClassWhitelistProvider") SerializableClassWhitelistProvider bambooHomeDirectoryClassWhitelistProvider, TrustedKeyService trustedKeyService) {
        this.bambooHomeDirectoryClassWhitelistProvider = bambooHomeDirectoryClassWhitelistProvider;
        this.trustedKeyService = trustedKeyService;
    }

    @Override
    public Set<String> getSerializableClassWhitelistFromBambooHome() {
        return ImmutableSet.copyOf((Iterable)this.bambooHomeDirectoryClassWhitelistProvider.getWhitelistedClasses());
    }

    @Override
    public Set<TrustedKey> getSshTrustedKeys() {
        return this.trustedKeyService.findAll().stream().map(TrustedKeyDTO.CONVERTER).collect(Collectors.toSet());
    }
}

