/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.server.control;

import com.atlassian.bamboo.deployments.environments.service.EnvironmentService;
import com.atlassian.bamboo.fileserver.SystemDirectory;
import com.atlassian.bamboo.persister.xstream.XStreamFactory;
import com.atlassian.bamboo.plan.NonBlockingPlanExecutionService;
import com.atlassian.bamboo.plan.cache.CachedPlanManager;
import com.atlassian.bamboo.plan.cache.ImmutableChain;
import com.atlassian.bamboo.server.control.ChangeDetectionController;
import com.atlassian.bamboo.spring.ComponentAccessor;
import com.atlassian.bamboo.trigger.TriggerActivatorHelper;
import com.atlassian.bamboo.trigger.TriggerTypeManager;
import com.atlassian.bamboo.trigger.Triggerable;
import com.atlassian.bamboo.util.BambooFileUtils;
import com.google.common.collect.Iterables;
import com.google.common.io.Closeables;
import io.atlassian.util.concurrent.Lazy;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.Future;
import java.util.function.Supplier;
import org.apache.commons.io.output.FileWriterWithEncoding;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChangeDetectionControllerImpl
implements ChangeDetectionController {
    private static final Logger log = Logger.getLogger(ChangeDetectionControllerImpl.class);
    private static final String SHUTDOWN_FILE = "shutdown.xml";
    private static final Charset SHUTDOWN_FILE_CHARSET = StandardCharsets.UTF_8;
    private final CachedPlanManager cachedPlanManager;
    private final EnvironmentService environmentService;
    private final TriggerTypeManager triggerTypeManager;
    private final XStreamFactory xStreamFactory;
    private final Supplier<ChangeDetectionController.ShutdownMarker> shutdownMarkerSupplier = Lazy.supplier(this::loadShutdownMarker);

    public ChangeDetectionControllerImpl(@NotNull CachedPlanManager cachedPlanManager, @NotNull EnvironmentService environmentService, @NotNull TriggerTypeManager triggerTypeManager, @NotNull XStreamFactory xStreamFactory) {
        this.cachedPlanManager = cachedPlanManager;
        this.environmentService = environmentService;
        this.triggerTypeManager = triggerTypeManager;
        this.xStreamFactory = xStreamFactory;
    }

    public Future<Boolean> shutdownChangeDetection() {
        Future changeDetectionStoppedFuture = ((NonBlockingPlanExecutionService)ComponentAccessor.NON_BLOCKING_PLAN_EXECUTION_SERVICE.get()).shutdown();
        ChangeDetectionController.ShutdownMarker shutdownMarker = new ChangeDetectionController.ShutdownMarker(System.currentTimeMillis());
        for (Triggerable triggerable : Iterables.concat((Iterable)this.cachedPlanManager.getPlans(ImmutableChain.class), (Iterable)this.environmentService.getAllEnvironmentsNoUserContext())) {
            TriggerActivatorHelper.deactivateTriggers(this.triggerTypeManager, triggerable, log);
        }
        this.saveShutdownMarker(shutdownMarker);
        return changeDetectionStoppedFuture;
    }

    @Nullable
    public ChangeDetectionController.ShutdownMarker getShutdownMarkerIfAvailable() {
        return this.shutdownMarkerSupplier.get();
    }

    private void saveShutdownMarker(ChangeDetectionController.ShutdownMarker shutdownMarker) {
        File shutdownFile = this.getShutdownMarkerFile();
        try (BufferedWriter out = new BufferedWriter((Writer)new FileWriterWithEncoding(shutdownFile, SHUTDOWN_FILE_CHARSET));){
            this.xStreamFactory.createCompactXStream().toXML((Object)shutdownMarker, (Writer)out);
        }
        catch (IOException e) {
            log.warn((Object)"Exception when writing shutdown marker file ", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ChangeDetectionController.ShutdownMarker loadShutdownMarker() {
        File shutdownFile = this.getShutdownMarkerFile();
        if (shutdownFile.exists()) {
            ChangeDetectionController.ShutdownMarker shutdownMarker;
            InputStreamReader in = new InputStreamReader((InputStream)new FileInputStream(shutdownFile), SHUTDOWN_FILE_CHARSET);
            try {
                shutdownMarker = (ChangeDetectionController.ShutdownMarker)this.xStreamFactory.createCompactXStream().fromXML((Reader)in);
            }
            catch (Throwable throwable) {
                try {
                    Closeables.closeQuietly((Reader)in);
                    BambooFileUtils.deleteQuietly(shutdownFile);
                    throw throwable;
                }
                catch (IOException e) {
                    log.warn((Object)"Exception when reading shutdown marker file ", (Throwable)e);
                }
            }
            Closeables.closeQuietly((Reader)in);
            BambooFileUtils.deleteQuietly(shutdownFile);
            return shutdownMarker;
        }
        return null;
    }

    private File getShutdownMarkerFile() {
        File serverStateDirectory = SystemDirectory.getServerStateDirectory();
        BambooFileUtils.createDirectoryIfNotExists(serverStateDirectory);
        return new File(serverStateDirectory, SHUTDOWN_FILE);
    }
}

