/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.setup;

import com.atlassian.bamboo.setup.BootstrapManager;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.config.PropertyPlaceholderConfigurer;

public class BambooBootstrapPlaceholderConfigurer
extends PropertyPlaceholderConfigurer {
    private static final Logger log = Logger.getLogger(BambooBootstrapPlaceholderConfigurer.class);
    private BootstrapManager bootstrapManager;

    protected String resolvePlaceholder(String placeholder, Properties props, int systemPropertiesMode) {
        String resolvedValue = super.resolvePlaceholder(placeholder, props, systemPropertiesMode);
        if (StringUtils.isEmpty((CharSequence)resolvedValue)) {
            String newPlaceHolder = placeholder.toUpperCase();
            newPlaceHolder = newPlaceHolder.replaceAll("\\.", "_");
            resolvedValue = super.resolvePlaceholder(newPlaceHolder, props, systemPropertiesMode);
        }
        return resolvedValue;
    }

    protected String resolvePlaceholder(String placeholder, Properties props) {
        Object o = this.bootstrapManager.getProperty(placeholder);
        if (o != null && o instanceof String) {
            return (String)o;
        }
        return props.getProperty(placeholder);
    }

    public void setBootstrapManager(BootstrapManager bootstrapManager) {
        this.bootstrapManager = bootstrapManager;
    }
}

