/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.specs;

import com.atlassian.bamboo.configuration.external.RepositoryStoredSpecsLogService;
import com.atlassian.bamboo.deployments.projects.service.DeploymentProjectService;
import com.atlassian.bamboo.plan.PlanKey;
import com.atlassian.bamboo.plan.VcsBambooSpecsSource;
import com.atlassian.bamboo.plan.VcsLocationBambooSpecsState;
import com.atlassian.bamboo.repository.RepositoryDataEntity;
import com.atlassian.bamboo.repository.RepositoryDefinitionDao;
import com.atlassian.bamboo.resultsummary.BuildResultsSummaryDao;
import com.atlassian.bamboo.resultsummary.ResultsSummaryCriteriaBuilder;
import com.atlassian.bamboo.specs.BambooSpecsManager;
import com.atlassian.bamboo.specs.BambooSpecsSourceDao;
import com.atlassian.bamboo.specs.BambooSpecsStateDao;
import com.atlassian.bamboo.utils.BambooPathUtils;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.primitives.Longs;
import java.nio.file.Path;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class BambooSpecsManagerImpl
implements BambooSpecsManager {
    private Logger log = Logger.getLogger(BambooSpecsManagerImpl.class);
    @VisibleForTesting
    public static final int MAX_SPECS_LOGS_RECORDS = 20;
    private static final int SEARCH_MAX_LIMIT = 100;
    @Inject
    private BambooSpecsStateDao bambooSpecsStateDao;
    @Inject
    private BambooSpecsSourceDao bambooSpecsSourceDao;
    @Inject
    private DeploymentProjectService deploymentProjectService;
    @Inject
    private RepositoryDefinitionDao repositoryDefinitionDao;
    @Inject
    private RepositoryStoredSpecsLogService repositorySpecsLogService;
    @Inject
    private BuildResultsSummaryDao buildResultsSummaryDao;

    public Optional<VcsLocationBambooSpecsState> findLatestState(long rootVcsRepositoryId, String branch) {
        return this.bambooSpecsStateDao.findLatestState(rootVcsRepositoryId, branch);
    }

    public void save(VcsLocationBambooSpecsState vcsLocationBambooSpecsState) {
        this.bambooSpecsStateDao.saveOrUpdate(vcsLocationBambooSpecsState);
    }

    public void save(VcsBambooSpecsSource vcsBambooSpecsSource) {
        this.bambooSpecsSourceDao.saveOrUpdate(vcsBambooSpecsSource);
    }

    public Optional<VcsBambooSpecsSource> findSourceById(long specsStateId) {
        return this.bambooSpecsSourceDao.findById(specsStateId);
    }

    @NotNull
    public Collection<PlanKey> findPlansInOtherStates(VcsLocationBambooSpecsState specsState) {
        return this.bambooSpecsStateDao.findPlansInOtherStates(specsState);
    }

    @NotNull
    public Collection<Long> findDeploymentProjectsInOtherStates(VcsLocationBambooSpecsState specsState) {
        return this.deploymentProjectService.findDeploymentProjectsInOtherStates(specsState);
    }

    @NotNull
    public List<VcsLocationBambooSpecsState> findByVcsLocationIdOrderBySpecsExecutionDate(long repositoryId, int limit) {
        return this.bambooSpecsStateDao.findByVcsLocationIdOrderBySpecsExecutionDate(repositoryId, limit);
    }

    public void updateAfterSpecsImport(VcsLocationBambooSpecsState vcsLocationBambooSpecsState, VcsLocationBambooSpecsState.SpecsImportState specsImportState, String logFilename) {
        vcsLocationBambooSpecsState.updateDataAfterSpecImport(logFilename, specsImportState);
        this.bambooSpecsStateDao.saveOrUpdate(vcsLocationBambooSpecsState);
    }

    public long removeOrphanedSpecStates() {
        AtomicLong counter = new AtomicLong(0L);
        HashSet<Long> specStateIds = new HashSet<Long>(this.getSpecStateIdsReferencedByBuildResults());
        this.log.info((Object)("Found " + specStateIds.size() + " specs states linked to result summary"));
        List repositories = this.repositoryDefinitionDao.getGlobalRepositoryDefinitions().stream().filter(this::hasMoreThanMaxBambooSpecsLogsRecords).collect(Collectors.toList());
        repositories.stream().flatMap(this::getAllButMax).filter(specsState -> this.isRemovable((VcsLocationBambooSpecsState)specsState, (Set<Long>)specStateIds)).forEach(specsState -> this.removeRecord(counter, (VcsLocationBambooSpecsState)specsState));
        return counter.get();
    }

    public List<VcsLocationBambooSpecsState> getUnfinishedSpecsScans() {
        return this.bambooSpecsStateDao.getUnfinishedSpecsScans();
    }

    private void removeRecord(AtomicLong counter, VcsLocationBambooSpecsState specsState) {
        try {
            Path logFile = this.repositorySpecsLogService.getBambooSpecsExecutionLogFile(specsState);
            this.bambooSpecsStateDao.delete(specsState);
            BambooPathUtils.deleteQuietly((Path)logFile);
        }
        catch (Exception e) {
            this.log.error((Object)e.getMessage(), (Throwable)e);
        }
        counter.incrementAndGet();
    }

    private Set<Long> getSpecStateIdsReferencedByBuildResults() {
        ResultsSummaryCriteriaBuilder criteriaBuilder = new ResultsSummaryCriteriaBuilder();
        criteriaBuilder.setSpecsResult(true).addCustomDataKey("specs.source.id");
        return this.buildResultsSummaryDao.findResultsSummaries(criteriaBuilder.buildCriteria()).stream().map(resultsSummary -> (String)resultsSummary.getCustomBuildData().get("specs.source.id")).map(Longs::tryParse).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    @NotNull
    private Stream<VcsLocationBambooSpecsState> getAllButMax(RepositoryDataEntity repository) {
        return this.bambooSpecsStateDao.findByVcsLocationIdOrderBySpecsExecutionDate(repository.getId(), 100).stream().skip(20L);
    }

    private boolean isRemovable(VcsLocationBambooSpecsState specsState, Set<Long> specsStateIds) {
        if (specsStateIds.contains(specsState.getId())) {
            return false;
        }
        return this.bambooSpecsStateDao.countPlansLinkedToState(specsState) == 0L;
    }

    private boolean hasMoreThanMaxBambooSpecsLogsRecords(RepositoryDataEntity repository) {
        return this.bambooSpecsStateDao.countStatesByRepositoryId(repository.getId()) > 20L;
    }
}

