/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.specs;

import com.atlassian.bamboo.hibernate.HibernateEntityObject;
import com.atlassian.bamboo.project.DefaultProject;
import com.atlassian.bamboo.project.Project;
import com.atlassian.bamboo.repository.RepositoryDataEntity;
import com.atlassian.bamboo.repository.RepositoryDataEntityImpl;
import com.atlassian.bamboo.specs.RssProjectPermission;
import javax.persistence.AttributeOverride;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.OnDelete;
import org.hibernate.annotations.OnDeleteAction;
import org.jetbrains.annotations.NotNull;

@Entity
@Table(name="RSS_PERMISSION_PROJECT", uniqueConstraints={@UniqueConstraint(columnNames={"PROJECT_ID", "REPOSITORY_ID"})})
@GenericGenerator(name="ImportAwareGenerator", strategy="com.atlassian.bamboo.persistence.ImportAwareGenerator")
@AttributeOverride(name="id", column=@Column(name="PERMISSION_ID"))
public class RssProjectPermissionImpl
extends HibernateEntityObject
implements RssProjectPermission {
    @JoinColumn(name="PROJECT_ID", nullable=false, updatable=false)
    @ManyToOne(targetEntity=DefaultProject.class, optional=false)
    @OnDelete(action=OnDeleteAction.CASCADE)
    private Project project;
    @JoinColumn(name="REPOSITORY_ID", nullable=false, updatable=false)
    @ManyToOne(targetEntity=RepositoryDataEntityImpl.class, optional=false)
    @OnDelete(action=OnDeleteAction.CASCADE)
    private RepositoryDataEntity repository;

    public RssProjectPermissionImpl() {
    }

    public RssProjectPermissionImpl(@NotNull Project project, @NotNull RepositoryDataEntity repository) {
        this.project = project;
        this.repository = repository;
    }

    @NotNull
    public Project getProject() {
        return this.project;
    }

    @NotNull
    public RepositoryDataEntity getRepository() {
        return this.repository;
    }

    public void setProject(Project project) {
        this.project = project;
    }

    public void setRepository(RepositoryDataEntity repositoryId) {
        this.repository = repositoryId;
    }
}

