/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.specs;

import com.atlassian.bamboo.hibernate.HibernateEntityObject;
import com.atlassian.bamboo.repository.RepositoryDataEntity;
import com.atlassian.bamboo.repository.RepositoryDataEntityImpl;
import com.atlassian.bamboo.specs.RssRepositoryPermission;
import javax.persistence.AttributeOverride;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.OnDelete;
import org.hibernate.annotations.OnDeleteAction;
import org.jetbrains.annotations.NotNull;

@Entity
@Table(name="RSS_PERMISSION_REPOSITORY", uniqueConstraints={@UniqueConstraint(columnNames={"TARGET_REPOSITORY_ID", "REPOSITORY_ID"})})
@GenericGenerator(name="ImportAwareGenerator", strategy="com.atlassian.bamboo.persistence.ImportAwareGenerator")
@AttributeOverride(name="id", column=@Column(name="PERMISSION_ID"))
public class RssRepositoryPermissionImpl
extends HibernateEntityObject
implements RssRepositoryPermission {
    @JoinColumn(name="TARGET_REPOSITORY_ID", nullable=false, updatable=false)
    @ManyToOne(targetEntity=RepositoryDataEntityImpl.class, optional=false)
    @OnDelete(action=OnDeleteAction.CASCADE)
    private RepositoryDataEntity targetRepository;
    @JoinColumn(name="REPOSITORY_ID", nullable=false, updatable=false)
    @ManyToOne(targetEntity=RepositoryDataEntityImpl.class, optional=false)
    @OnDelete(action=OnDeleteAction.NO_ACTION)
    private RepositoryDataEntity repository;

    public RssRepositoryPermissionImpl() {
    }

    public RssRepositoryPermissionImpl(@NotNull RepositoryDataEntity targetRepository, @NotNull RepositoryDataEntity repository) {
        this.targetRepository = targetRepository;
        this.repository = repository;
    }

    @NotNull
    public RepositoryDataEntity getTargetRepository() {
        return this.targetRepository;
    }

    @NotNull
    public RepositoryDataEntity getRepository() {
        return this.repository;
    }

    public void setTargetRepository(RepositoryDataEntity targetRepository) {
        this.targetRepository = targetRepository;
    }

    public void setRepository(RepositoryDataEntity repositoryId) {
        this.repository = repositoryId;
    }
}

