/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.specs.yaml;

import com.atlassian.bamboo.specs.api.validators.common.ImporterUtils;
import com.atlassian.bamboo.specs.api.validators.common.ValidationContext;
import com.atlassian.bamboo.specs.yaml.ListNode;
import com.atlassian.bamboo.specs.yaml.MapNode;
import com.atlassian.bamboo.specs.yaml.Node;
import com.atlassian.bamboo.specs.yaml.StringNode;
import com.atlassian.bamboo.util.BambooConstantUtils;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BambooYamlParserUtils {
    public static final String CFG_VERSION = (String)BambooConstantUtils.preventInlining((Object)"version");

    private BambooYamlParserUtils() {
    }

    @NotNull
    public static Node asNode(@Nullable Object obj, @NotNull ValidationContext validationContext) {
        if (obj == null) {
            return new MapNode(Collections.emptyMap(), validationContext);
        }
        if (obj instanceof Map) {
            return new MapNode(BambooYamlParserUtils.checkMapType(validationContext, (Map)obj), validationContext);
        }
        if (obj instanceof List) {
            return ListNode.fromList((List)obj, validationContext);
        }
        if (obj instanceof Number || obj instanceof Boolean || obj instanceof Date) {
            return new StringNode(obj.toString(), validationContext);
        }
        String stringValue = BambooYamlParserUtils.checkType(validationContext, obj, String.class);
        return new StringNode(stringValue, validationContext);
    }

    @Contract(value="_, null -> fail; _, !null -> !null")
    public static <T> T checkRequired(@NotNull ValidationContext validationContext, @Nullable T value) {
        ImporterUtils.checkThat((ValidationContext)validationContext, (value != null ? 1 : 0) != 0, (String)"Property is required.", (Object[])new Object[0]);
        return value;
    }

    @NotNull
    public static <T> T checkPresent(@NotNull ValidationContext validationContext, @NotNull Optional<T> value) {
        ImporterUtils.checkThat((ValidationContext)validationContext, (boolean)value.isPresent(), (String)"Property is required.", (Object[])new Object[0]);
        return value.get();
    }

    @NotNull
    public static <T> T checkType(@NotNull ValidationContext validationContext, @Nullable Object value, @NotNull Class<T> expectedType) {
        BambooYamlParserUtils.checkRequired(validationContext, value);
        ImporterUtils.checkThat((ValidationContext)validationContext, (boolean)expectedType.isInstance(value), (String)"Element [%s] is of wrong type. Expected %s, found %s.", (Object[])new Object[]{value, expectedType.getSimpleName(), BambooYamlParserUtils.getTypeOrInterface(value)});
        return expectedType.cast(value);
    }

    @NotNull
    public static <T extends Node> T checkType(@NotNull Node node, @NotNull Class<T> expectedType) {
        ImporterUtils.checkThat((ValidationContext)node.getValidationContext(), (boolean)expectedType.isInstance(node), (String)"Element is of wrong type. Expected %s, found %s.", (Object[])new Object[]{expectedType.getSimpleName(), BambooYamlParserUtils.getTypeOrInterface(node)});
        return (T)((Node)expectedType.cast(node));
    }

    @NotNull
    private static String getTypeOrInterface(@Nullable Object value) {
        if (value == null) {
            return "null";
        }
        if (value instanceof Map) {
            return Map.class.getSimpleName();
        }
        if (value instanceof List) {
            return List.class.getSimpleName();
        }
        return value.getClass().getSimpleName();
    }

    @NotNull
    public static <T extends Node> List<T> checkListType(@NotNull List<? extends Node> list, @NotNull Class<T> expectedType) {
        return list.stream().map(element -> BambooYamlParserUtils.checkType(element, expectedType)).collect(Collectors.toList());
    }

    @NotNull
    public static Map<String, Object> checkMapType(@NotNull ValidationContext validationContext, @NotNull Map<?, ?> value) {
        return BambooYamlParserUtils.checkMapType(validationContext, value, String.class, Object.class);
    }

    @NotNull
    public static <K, V> Map<K, V> checkMapType(@NotNull ValidationContext validationContext, @NotNull Map<?, ?> value, @NotNull Class<K> expectedKeyType, @NotNull Class<V> expectedValueType) {
        return value.entrySet().stream().collect(Collectors.toMap(entry -> BambooYamlParserUtils.checkType(validationContext, entry.getKey(), expectedKeyType), entry -> BambooYamlParserUtils.checkType(validationContext.with((String)entry.getKey()), entry.getValue(), expectedValueType)));
    }

    @NotNull
    public static String checkStringNotBlank(@NotNull ValidationContext validationContext, @Nullable String value) {
        ImporterUtils.checkThat((ValidationContext)validationContext, (boolean)StringUtils.isNotBlank((CharSequence)value), (String)"String must not be empty.", (Object[])new Object[0]);
        return value;
    }

    @NotNull
    public static <T> List<T> checkListNotEmpty(@NotNull ValidationContext validationContext, @Nullable List<T> list) {
        ImporterUtils.checkThat((ValidationContext)validationContext, (boolean)CollectionUtils.isNotEmpty(list), (String)"List must not be empty.", (Object[])new Object[0]);
        return list;
    }
}

