/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.specs.yaml;

import com.atlassian.bamboo.specs.api.validators.common.ValidationContext;
import com.atlassian.bamboo.specs.yaml.BambooYamlParserUtils;
import com.atlassian.bamboo.specs.yaml.BaseNode;
import com.atlassian.bamboo.specs.yaml.Node;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;

public class ListNode<T extends Node>
extends BaseNode {
    private final List<T> list;

    @NotNull
    public static ListNode<Node> fromList(@NotNull List<?> list, @NotNull ValidationContext validationContext) {
        ArrayList<Node> mappedList = new ArrayList<Node>();
        for (int i = 0; i < list.size(); ++i) {
            mappedList.add(BambooYamlParserUtils.asNode(list.get(i), validationContext.with("[" + i + "]")));
        }
        return new ListNode<Node>(mappedList, validationContext);
    }

    public ListNode(@NotNull List<T> list, @NotNull ValidationContext validationContext) {
        super(validationContext);
        this.list = new ArrayList<T>(list);
    }

    @NotNull
    public Stream<T> stream() {
        return this.list.stream();
    }

    @NotNull
    public <X extends Node> ListNode<X> asListOf(@NotNull Class<X> expectedType) {
        return new ListNode<X>(BambooYamlParserUtils.checkListType(this.list, expectedType), this.getValidationContext());
    }

    @NotNull
    public List<T> getList() {
        return this.list;
    }

    @NotNull
    public List<String> getUnusedProperties() {
        return this.list.stream().map(Node::getUnusedProperties).flatMap(Collection::stream).collect(Collectors.toList());
    }
}

