/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.specs.yaml;

import com.atlassian.bamboo.specs.api.validators.common.ValidationContext;
import com.atlassian.bamboo.specs.yaml.BambooYamlParserUtils;
import com.atlassian.bamboo.specs.yaml.BaseNode;
import com.atlassian.bamboo.specs.yaml.ListNode;
import com.atlassian.bamboo.specs.yaml.Node;
import com.atlassian.bamboo.specs.yaml.StringNode;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;

public class MapNode
extends BaseNode {
    private final Map<String, Node> structure;
    private final Set<String> visited = new HashSet<String>();

    public MapNode(@NotNull Map<String, Object> structure, @NotNull ValidationContext validationContext) {
        super(validationContext);
        this.structure = new LinkedHashMap<String, Node>();
        structure.forEach((key, val) -> this.structure.put((String)key, BambooYamlParserUtils.asNode(val, validationContext.with(key))));
    }

    @NotNull
    public StringNode getString(@NotNull String property) {
        return BambooYamlParserUtils.checkPresent(this.getValidationContext().with(property), this.getOptionalString(property));
    }

    @NotNull
    public Optional<StringNode> getOptionalString(@NotNull String property) {
        return this.getOptionalNode(property).map(node -> BambooYamlParserUtils.checkType(node, StringNode.class));
    }

    @NotNull
    public <T extends Node> ListNode<T> getList(@NotNull String property, @NotNull Class<T> expectedType) {
        ListNode<T> listNode = BambooYamlParserUtils.checkPresent(this.getValidationContext().with(property), this.getOptionalList(property, expectedType));
        BambooYamlParserUtils.checkListNotEmpty(listNode.getValidationContext(), listNode.getList());
        return listNode;
    }

    @NotNull
    public <T extends Node> Optional<ListNode<T>> getOptionalList(@NotNull String property, @NotNull Class<T> expectedType) {
        return this.getOptionalNode(property).map(node -> BambooYamlParserUtils.checkType(node, ListNode.class)).map(listNode -> listNode.asListOf(expectedType));
    }

    @NotNull
    public MapNode getMap(@NotNull String property) {
        return BambooYamlParserUtils.checkPresent(this.getValidationContext().with(property), this.getOptionalMap(property));
    }

    @NotNull
    public Optional<MapNode> getOptionalMap(@NotNull String property) {
        return this.getOptionalNode(property).map(node -> BambooYamlParserUtils.checkType(node, MapNode.class));
    }

    @NotNull
    public Node getNode(@NotNull String property) {
        return BambooYamlParserUtils.checkPresent(this.getValidationContext().with(property), this.getOptionalNode(property));
    }

    @NotNull
    public Optional<Node> getOptionalNode(@NotNull String property) {
        this.visited.add(property);
        return Optional.ofNullable(this.structure.getOrDefault(property, null));
    }

    @NotNull
    public List<String> getUnusedProperties() {
        return this.structure.entrySet().stream().filter(entry -> !BambooYamlParserUtils.CFG_VERSION.equals(entry.getKey())).flatMap(entry -> this.visited.contains(entry.getKey()) ? ((Node)entry.getValue()).getUnusedProperties().stream() : Stream.of(((Node)entry.getValue()).getValidationContext().toString())).collect(Collectors.toList());
    }

    @NotNull
    public Collection<String> getProperties() {
        return this.structure.keySet();
    }
}

