/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.spring;

import com.atlassian.bamboo.spring.ComponentAccessor;
import com.google.common.base.Supplier;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.springframework.beans.factory.FactoryBean;

public class LazyComponentProxyFactoryBean
implements FactoryBean {
    private final Class<?> interfaceClass;
    private final Object proxy;

    public LazyComponentProxyFactoryBean(Class<?> interfaceClass, String componentName) {
        this.interfaceClass = interfaceClass;
        this.proxy = Proxy.newProxyInstance(interfaceClass.getClassLoader(), new Class[]{interfaceClass}, (InvocationHandler)new LazyInvocationHandler(componentName));
    }

    public Object getObject() {
        return this.proxy;
    }

    public Class<?> getObjectType() {
        return this.interfaceClass;
    }

    public boolean isSingleton() {
        return true;
    }

    private static final class LazyInvocationHandler
    implements InvocationHandler {
        private final Supplier<Object> componentRef;

        public LazyInvocationHandler(String componentName) {
            this.componentRef = ComponentAccessor.newLazyComponentReference(componentName);
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            return method.invoke(this.componentRef.get(), args);
        }
    }
}

