/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.spring;

import com.google.common.base.Preconditions;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.Connection;
import java.util.concurrent.atomic.AtomicReference;

public final class NonLeakableConnection {
    private static final Class<?>[] PROXY_INTERFACES = new Class[]{Connection.class};
    private static final Method CLOSE_METHOD = NonLeakableConnection.getCloseMethod();

    private NonLeakableConnection() {
    }

    public static Connection wrap(Connection delegate) {
        Preconditions.checkNotNull((Object)delegate);
        final AtomicReference<Connection> connectionRef = new AtomicReference<Connection>(delegate);
        return (Connection)Proxy.newProxyInstance(delegate.getClass().getClassLoader(), PROXY_INTERFACES, new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
                Connection connection = (Connection)connectionRef.get();
                Preconditions.checkState((connection != null ? 1 : 0) != 0, (Object)"Connections cannot be used outside of TransactionalExecutor");
                if (method.equals(CLOSE_METHOD)) {
                    connectionRef.set(null);
                    return null;
                }
                return method.invoke((Object)connection, args);
            }
        });
    }

    private static Method getCloseMethod() {
        try {
            return Connection.class.getMethod("close", new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }
}

