/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.spring;

import com.atlassian.bamboo.spring.AbstractTransactionalExecutor;
import com.atlassian.bamboo.spring.NonLeakableConnection;
import com.atlassian.bamboo.util.BambooSpringUtils;
import com.atlassian.bamboo.utils.db.DbmsBean;
import com.atlassian.sal.api.rdbms.ConnectionCallback;
import java.sql.Connection;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.jetbrains.annotations.NotNull;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionOperations;
import org.springframework.transaction.support.TransactionTemplate;

class PluginSpringHibernateTransactionalExecutor
extends AbstractTransactionalExecutor {
    private final TransactionTemplate transactionTemplate;
    private final SessionFactory sessionFactory;
    private static final ThreadLocal<AtomicInteger> NESTING_LEVEL = new ThreadLocal();

    PluginSpringHibernateTransactionalExecutor(TransactionTemplate transactionTemplate, SessionFactory sessionFactory, DbmsBean dbmsBean, boolean readOnly, boolean requiresNewTx) {
        super(dbmsBean, readOnly, requiresNewTx);
        this.transactionTemplate = transactionTemplate;
        this.sessionFactory = sessionFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <A> A execute(@NotNull ConnectionCallback<A> callback) {
        try {
            boolean isFirstCall;
            AtomicInteger level = NESTING_LEVEL.get();
            boolean bl = isFirstCall = level == null;
            if (isFirstCall) {
                NESTING_LEVEL.set(new AtomicInteger(1));
            } else {
                NESTING_LEVEL.get().incrementAndGet();
            }
            Object object = this.newTransactionTemplate(isFirstCall).execute(this.toSpringCallback(callback));
            return (A)object;
        }
        finally {
            int nestingLevel = NESTING_LEVEL.get().decrementAndGet();
            if (nestingLevel == 0) {
                NESTING_LEVEL.remove();
            }
        }
    }

    private <A> TransactionCallback<A> toSpringCallback(@NotNull ConnectionCallback<A> callback) {
        return status -> {
            Session session = this.sessionFactory.getCurrentSession();
            AtomicReference result = new AtomicReference();
            session.doWork(nativeConnection -> {
                try (Connection wrappedConnection = NonLeakableConnection.wrap(nativeConnection);){
                    result.set(callback.execute(wrappedConnection));
                }
            });
            return result.get();
        };
    }

    private TransactionOperations newTransactionTemplate(boolean forceNewTx) {
        return BambooSpringUtils.clone(this.transactionTemplate, this.requiresNewTx || forceNewTx, this.readOnly);
    }
}

