/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.spring;

import com.google.common.base.Preconditions;
import java.lang.reflect.Proxy;
import java.util.function.Supplier;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.Nullable;

class ProxyFactoryBeanDataHolder {
    private static final Logger log = Logger.getLogger(ProxyFactoryBeanDataHolder.class);
    private static final String SUBCLASS_MATCH_INDICATOR = "*";
    private final boolean isLenientTypeCheck;
    private volatile String classNameForTypeCheck;

    ProxyFactoryBeanDataHolder(String classNameForTypeCheck) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)classNameForTypeCheck), (Object)"No class provided");
        if (classNameForTypeCheck.startsWith(SUBCLASS_MATCH_INDICATOR)) {
            this.isLenientTypeCheck = true;
            this.classNameForTypeCheck = StringUtils.substringAfter((String)classNameForTypeCheck, (String)SUBCLASS_MATCH_INDICATOR);
        } else {
            this.isLenientTypeCheck = false;
            this.classNameForTypeCheck = classNameForTypeCheck;
        }
    }

    @Nullable
    private Class<?> findClass(String className) {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            log.warn((Object)("Couldn't find " + className), (Throwable)e);
            return null;
        }
    }

    public Class<?> getObjectType(Supplier<Class<?>> supplier) {
        return this.classNameForTypeCheck != null ? this.findClass(this.classNameForTypeCheck) : supplier.get();
    }

    public void assertIsReset() {
        Preconditions.checkState((this.classNameForTypeCheck == null ? 1 : 0) != 0, (Object)"Factory bean target was set without clearing type check data");
    }

    public void assertSameTypes(Class<?> actualTargetClass) {
        if (Proxy.isProxyClass(actualTargetClass)) {
            return;
        }
        Class classUsedForTypeCheck = (Class)Preconditions.checkNotNull(this.findClass(this.classNameForTypeCheck), (Object)("Class " + this.classNameForTypeCheck + " not found"));
        if (this.isLenientTypeCheck) {
            boolean assignableFrom = classUsedForTypeCheck.isAssignableFrom(actualTargetClass);
            Preconditions.checkArgument((boolean)assignableFrom, (Object)("Actual target class " + actualTargetClass + " is not assignable to class requested for the type check: " + actualTargetClass));
        } else {
            boolean sameClass = actualTargetClass.equals(classUsedForTypeCheck);
            Preconditions.checkArgument((boolean)sameClass, (Object)("Class used for type check " + classUsedForTypeCheck + " is not equal to the actual target class " + actualTargetClass));
        }
    }

    public String reset() {
        String rc = this.classNameForTypeCheck;
        this.classNameForTypeCheck = null;
        return rc;
    }
}

