/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.storage;

import com.atlassian.bamboo.ResultKey;
import com.atlassian.bamboo.build.BuildExecutionManager;
import com.atlassian.bamboo.plan.PlanResultKey;
import com.atlassian.bamboo.storage.event.ArtifactStorageHardLimitExceededEvent;
import com.atlassian.bamboo.utils.BambooFunctions;
import com.atlassian.bamboo.v2.build.CurrentlyBuilding;
import com.atlassian.bamboo.v2.build.queue.BuildQueueManager;
import com.atlassian.event.api.EventListener;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import javax.inject.Inject;
import org.apache.log4j.Logger;

public class ArtifactStorageBuildStoppingListener {
    private static final Logger log = Logger.getLogger(ArtifactStorageBuildStoppingListener.class);
    @Inject
    private BuildExecutionManager buildExecutionManager;
    @Inject
    private BuildQueueManager buildQueueManager;

    @EventListener
    public void onHardLimitExceededEvent(ArtifactStorageHardLimitExceededEvent event) {
        Iterable buildResultKeys = Iterables.filter((Iterable)this.buildQueueManager.getQueuedExecutables(), (Predicate)Predicates.compose(PlanResultKey.class::isInstance, BambooFunctions.getResultKey()));
        for (BuildQueueManager.QueuedResultKey resultKey : buildResultKeys) {
            ResultKey resultKey1 = resultKey.getResultKey();
            log.info((Object)("Cancelling queued build " + resultKey1 + " as hard storage limit has been exceeded"));
            this.buildQueueManager.removeBuildFromQueue(resultKey1);
        }
        for (CurrentlyBuilding build : this.buildExecutionManager.getCurrentlyExecuting()) {
            PlanResultKey planResultKey = build.getBuildIdentifier().getPlanResultKey();
            if (planResultKey.equals((Object)event.getCause())) {
                log.info((Object)("Not stopping " + planResultKey + " as this result is a cause of exceeding hard storage limit"));
                continue;
            }
            log.info((Object)("Stopping currently building " + planResultKey + " build as hard storage limit has been exceeded"));
            this.buildExecutionManager.finishBuild(planResultKey, true);
        }
    }
}

