/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.storage;

import com.atlassian.bamboo.FeatureManager;
import com.atlassian.bamboo.bandana.PlanAwareBandanaContext;
import com.atlassian.bamboo.build.artifact.handlers.ArtifactHandlersService;
import com.atlassian.bamboo.configuration.AdministrationConfigurationAccessor;
import com.atlassian.bamboo.configuration.StorageLimits;
import com.atlassian.bamboo.plan.PlanResultKey;
import com.atlassian.bamboo.storage.DiskUsageManager;
import com.atlassian.bamboo.storage.StorageCappingService;
import com.atlassian.bamboo.storage.event.ArtifactStorageHardLimitExceededEvent;
import com.atlassian.bamboo.storage.event.ArtifactStorageSoftLimitExceededEvent;
import com.atlassian.bandana.BandanaContext;
import com.atlassian.bandana.BandanaManager;
import com.atlassian.event.api.EventPublisher;
import com.google.common.annotations.VisibleForTesting;
import java.util.Set;
import javax.inject.Inject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.stereotype.Component;

@Component
public class StorageCappingServiceImpl
implements StorageCappingService {
    private static final BandanaContext BANDANA_CONTEXT = PlanAwareBandanaContext.GLOBAL_CONTEXT;
    @VisibleForTesting
    static final String CFG_SOFT_LIMIT_NOTIFICATION_SENT = "storage.capping.soft.limit.notification.sent";
    @VisibleForTesting
    static final String CFG_HARD_LIMIT_NOTIFICATION_SENT = "storage.capping.hard.limit.notification.sent";
    private volatile boolean isSoftLimitExceeded = false;
    private volatile boolean isHardLimitExceeded = false;
    @Inject
    private AdministrationConfigurationAccessor administrationConfigurationAccessor;
    @Inject
    private ArtifactHandlersService artifactHandlersService;
    @Inject
    private BandanaManager bandanaManager;
    @Inject
    private DiskUsageManager diskUsageManager;
    @Inject
    private EventPublisher eventPublisher;
    @Inject
    private FeatureManager featureManager;

    public boolean isHardLimitExceeded() {
        return this.isFeatureEnabled() && this.isHardLimitExceeded;
    }

    public boolean isSoftLimitExceeded() {
        return this.isFeatureEnabled() && this.isSoftLimitExceeded;
    }

    public void onArtifactUpdated(@Nullable PlanResultKey cause, long artifactSize) {
        if (this.isFeatureEnabled()) {
            this.diskUsageManager.invalidateDiskUsageByArtifacts();
            if (artifactSize >= 0L || Boolean.TRUE.equals(this.bandanaManager.getValue(BANDANA_CONTEXT, CFG_SOFT_LIMIT_NOTIFICATION_SENT))) {
                this.updateLimitExceededFlags();
                this.handleHardLimitExceeded(this.isHardLimitExceeded, cause);
                this.handleSoftLimitExceeded(this.isSoftLimitExceeded);
            }
        }
    }

    public void initializeStorageLimits() {
        this.onArtifactUpdated(null, 0L);
    }

    private void updateLimitExceededFlags() {
        Set artifactHandlerKeys = this.artifactHandlersService.getEnabledArtifactHandlerKeys();
        long currentDiskUsage = 0L;
        for (String pluginKey : artifactHandlerKeys) {
            Long usage = this.diskUsageManager.findUsedStorageByArtifactHandler(pluginKey);
            if (usage == null) continue;
            currentDiskUsage = (long)((double)currentDiskUsage + (double)usage.longValue());
        }
        double diskUsageGb = (double)currentDiskUsage / 1.073741824E9;
        this.isHardLimitExceeded = diskUsageGb > (double)this.getStorageLimits().getHardLimit();
        this.isSoftLimitExceeded = diskUsageGb > (double)this.getStorageLimits().getSoftLimit();
    }

    private boolean isFeatureEnabled() {
        return this.featureManager.isArtifactStorageSpaceLimited();
    }

    @NotNull
    private StorageLimits getStorageLimits() {
        return this.administrationConfigurationAccessor.getAdministrationConfiguration().getStorageLimit();
    }

    private void handleSoftLimitExceeded(boolean softLimitExceeded) {
        boolean notificationSent = Boolean.TRUE.equals(this.bandanaManager.getValue(BANDANA_CONTEXT, CFG_SOFT_LIMIT_NOTIFICATION_SENT));
        if (softLimitExceeded && !notificationSent) {
            this.eventPublisher.publish((Object)new ArtifactStorageSoftLimitExceededEvent(this.getStorageLimits()));
            this.bandanaManager.setValue(BANDANA_CONTEXT, CFG_SOFT_LIMIT_NOTIFICATION_SENT, (Object)true);
        } else if (!softLimitExceeded && notificationSent) {
            this.bandanaManager.setValue(BANDANA_CONTEXT, CFG_SOFT_LIMIT_NOTIFICATION_SENT, (Object)false);
        }
    }

    private void handleHardLimitExceeded(boolean hardLimitExceeded, @Nullable PlanResultKey cause) {
        boolean notificationSent = Boolean.TRUE.equals(this.bandanaManager.getValue(BANDANA_CONTEXT, CFG_HARD_LIMIT_NOTIFICATION_SENT));
        if (hardLimitExceeded && !notificationSent) {
            this.eventPublisher.publish((Object)new ArtifactStorageHardLimitExceededEvent(this.getStorageLimits(), cause));
            this.bandanaManager.setValue(BANDANA_CONTEXT, CFG_HARD_LIMIT_NOTIFICATION_SENT, (Object)true);
            this.bandanaManager.setValue(BANDANA_CONTEXT, CFG_SOFT_LIMIT_NOTIFICATION_SENT, (Object)true);
        } else if (!hardLimitExceeded && notificationSent) {
            this.bandanaManager.setValue(BANDANA_CONTEXT, CFG_HARD_LIMIT_NOTIFICATION_SENT, (Object)false);
        }
    }
}

