/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.storage.location;

import com.atlassian.bamboo.artifact.Artifact;
import com.atlassian.bamboo.plan.PlanKey;
import com.atlassian.bamboo.plan.PlanResultKey;
import com.atlassian.bamboo.plan.artifact.ImmutableArtifactDefinitionBase;
import com.atlassian.bamboo.storage.ArtifactDirectoryBuilder;
import com.atlassian.bamboo.storage.ArtifactPathBuilder;
import com.atlassian.bamboo.storage.location.ArtifactPathBuilderImpl;
import java.io.File;

public class ArtifactDirectoryBuilderImpl
implements ArtifactDirectoryBuilder {
    private final ArtifactPathBuilder pathBuilder;

    public ArtifactDirectoryBuilderImpl(ArtifactPathBuilder pathBuilder) {
        this.pathBuilder = pathBuilder;
    }

    public File getRootDirectory() {
        return new File(this.pathBuilder.getRootPath());
    }

    public File getTemporaryDirectory() {
        return new File(this.pathBuilder.getTemporaryPath());
    }

    public File getArtifactDirectory(Artifact artifact) {
        return new File(this.pathBuilder.getArtifactPath(artifact));
    }

    public File getPlanOrientedArtifactDirectory(PlanResultKey planResultKey, ImmutableArtifactDefinitionBase artifactDefinition) {
        return new File(this.pathBuilder.getPlanOrientedArtifactPath(planResultKey, artifactDefinition));
    }

    public File getChainDirectory(PlanKey planKey) {
        return new File(this.pathBuilder.getChainPath(planKey));
    }

    public File getJobOrSharedDirectory(PlanKey planKey) {
        return new File(this.pathBuilder.getJobOrSharedPath(planKey));
    }

    public File getBuildDirectory(PlanResultKey planResultKey) {
        return new File(this.pathBuilder.getBuildPath(planResultKey));
    }

    public static boolean isArtifactDirectory(File directory) {
        String parentDirectoryName = directory.getParentFile().getName();
        return ArtifactPathBuilderImpl.isBuildPart(parentDirectoryName) || ArtifactPathBuilderImpl.isGlobalStorageDirectoryName(parentDirectoryName);
    }
}

