/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.storage.location;

import com.atlassian.annotations.Internal;
import com.atlassian.bamboo.setup.BootstrapManager;
import com.atlassian.bamboo.storage.ArtifactDirectoryBuilder;
import com.atlassian.bamboo.storage.ArtifactPathBuilder;
import com.atlassian.bamboo.storage.location.ArtifactDirectoryBuilderImpl;
import com.atlassian.bamboo.storage.location.ArtifactPathBuilderFactory;
import com.atlassian.bamboo.storage.location.ArtifactPathBuilderImpl;
import com.google.common.base.Preconditions;
import java.io.File;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.AutowireCapableBeanFactory;

public class ArtifactPathBuilderFactoryImpl
implements ArtifactPathBuilderFactory {
    @Inject
    private AutowireCapableBeanFactory beanFactory;
    @Autowired(required=false)
    private BootstrapManager bootstrapManager;

    @Override
    public ArtifactPathBuilder createArtifactPathBuilder(String rootArtifactPath, char separatorChar) {
        ArtifactPathBuilderImpl builder = new ArtifactPathBuilderImpl(rootArtifactPath, separatorChar);
        this.beanFactory.autowireBean((Object)builder);
        return builder;
    }

    @Override
    public ArtifactPathBuilder createArtifactPathBuilder(char separatorChar) {
        ArtifactPathBuilderImpl builder = new ArtifactPathBuilderImpl(separatorChar);
        this.beanFactory.autowireBean((Object)builder);
        return builder;
    }

    @Override
    public ArtifactDirectoryBuilder createArtifactDirectoryBuilder(File rootArtifactDirectory) {
        ArtifactPathBuilder pathBuilder = this.createArtifactPathBuilder(rootArtifactDirectory.getAbsolutePath(), File.separatorChar);
        return new ArtifactDirectoryBuilderImpl(pathBuilder);
    }

    @Override
    public ArtifactDirectoryBuilder createDefaultArtifactDirectoryBuilder() {
        Preconditions.checkState((this.bootstrapManager != null ? 1 : 0) != 0);
        File artifactsDir = ArtifactPathBuilderFactoryImpl.getRootArtifactDirectory(this.bootstrapManager);
        artifactsDir.mkdirs();
        return this.createArtifactDirectoryBuilder(artifactsDir);
    }

    @Internal
    @NotNull
    public static File getRootArtifactDirectory(BootstrapManager bootstrapManager) {
        String rootArtifactPath = (String)StringUtils.defaultIfEmpty((CharSequence)bootstrapManager.getArtifactsDirectory(), (CharSequence)"/");
        return new File(rootArtifactPath);
    }
}

