/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.storage.location;

import com.atlassian.bamboo.artifact.Artifact;
import com.atlassian.bamboo.plan.PlanKey;
import com.atlassian.bamboo.plan.PlanKeys;
import com.atlassian.bamboo.plan.PlanResultKey;
import com.atlassian.bamboo.plan.artifact.ImmutableArtifactDefinitionBase;
import com.atlassian.bamboo.storage.ArtifactPathBuilder;
import com.atlassian.bamboo.storage.location.StorageTagService;
import com.atlassian.bamboo.util.BambooFilenameUtils;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.Nullable;

public class ArtifactPathBuilderImpl
implements ArtifactPathBuilder {
    private static final String GLOBAL_STORAGE_DIRECTORY = "globalStorage";
    private static final String TEMPORARY_STORAGE_DIRECTORY = "tmp";
    private static final String BUILD_PART_PREFIX = "build-";
    private static final String BUILD_PART_FORMAT = "build-%05d";
    @Inject
    private StorageTagService storageTagService;
    private String rootPath;
    private Joiner pathJoiner;

    public ArtifactPathBuilderImpl(String rootPath, char separatorChar) {
        this.rootPath = rootPath;
        this.pathJoiner = Joiner.on((char)separatorChar).skipNulls();
    }

    public ArtifactPathBuilderImpl(char separatorChar) {
        this(null, separatorChar);
    }

    public String getRootPath() {
        return this.rootPath;
    }

    public String getTemporaryPath() {
        return this.toPath(TEMPORARY_STORAGE_DIRECTORY);
    }

    public String getArtifactPath(Artifact artifact) {
        if (artifact.isGloballyStored()) {
            return this.getGlobalArtifactPath(artifact.getId());
        }
        return this.getPlanOrientedArtifactPath(artifact.getPlanResultKey(), artifact.isSharedArtifact(), artifact.getLabel());
    }

    private String getGlobalArtifactPath(long artifactId) {
        return this.toPath(GLOBAL_STORAGE_DIRECTORY, Long.toString(artifactId));
    }

    public String getPlanOrientedArtifactPath(PlanResultKey planResultKey, @Nullable ImmutableArtifactDefinitionBase artifactDefinition) {
        boolean isSharedArtifact = artifactDefinition != null && artifactDefinition.isSharedArtifact();
        String artifactLabel = artifactDefinition != null ? artifactDefinition.getName() : null;
        return this.getPlanOrientedArtifactPath(planResultKey, isSharedArtifact, artifactLabel);
    }

    private String getPlanOrientedArtifactPath(PlanResultKey planResultKey, boolean isSharedArtifact, @Nullable String artifactLabel) {
        Preconditions.checkArgument((!BambooFilenameUtils.containsDirectoryTraversalString((String)artifactLabel) ? 1 : 0) != 0, (String)"Artifact name '%s' cannot contain directory traversal characters", (Object[])new Object[]{artifactLabel});
        PlanKey planKey = planResultKey.getPlanKey();
        String chainPart = this.getChainPart(planKey);
        String jobPart = ArtifactPathBuilderImpl.getJobPartForArtifact(planKey, isSharedArtifact);
        String buildPart = ArtifactPathBuilderImpl.getBuildPart(planResultKey.getBuildNumber());
        String labelPart = ArtifactPathBuilderImpl.getLabelPart(artifactLabel);
        return this.toPath(chainPart, jobPart, buildPart, labelPart);
    }

    public String getChainPath(PlanKey planKey) {
        return this.toPath(this.getChainPart(planKey));
    }

    public String getJobOrSharedPath(PlanKey planKey) {
        return this.toPath(this.getChainPart(planKey), ArtifactPathBuilderImpl.getJobPartForPlan(planKey));
    }

    public String getBuildPath(PlanResultKey planResultKey) {
        PlanKey planKey = planResultKey.getPlanKey();
        return this.toPath(this.getChainPart(planKey), ArtifactPathBuilderImpl.getJobPartForPlan(planKey), ArtifactPathBuilderImpl.getBuildPart(planResultKey.getBuildNumber()));
    }

    private String toPath(String ... parts) {
        return this.pathJoiner.join((Object)this.rootPath, (Object)this.pathJoiner.join((Object[])parts), new Object[0]);
    }

    private String getChainPart(PlanKey planKey) {
        PlanKey chainKey = PlanKeys.isJobKey((PlanKey)planKey) ? PlanKeys.getChainKeyFromJobKey((PlanKey)planKey) : planKey;
        return this.storageTagService.getChainStorageTag(chainKey).toString();
    }

    private static String getJobPartForPlan(PlanKey planKey) {
        return PlanKeys.isJobKey((PlanKey)planKey) ? PlanKeys.getPartialJobKey((PlanKey)planKey) : "shared";
    }

    private static String getJobPartForArtifact(PlanKey planKey, boolean isSharedArtifact) {
        return !isSharedArtifact && PlanKeys.isJobKey((PlanKey)planKey) ? PlanKeys.getPartialJobKey((PlanKey)planKey) : "shared";
    }

    @VisibleForTesting
    static String getBuildPart(int buildNumber) {
        return String.format(BUILD_PART_FORMAT, buildNumber);
    }

    static boolean isBuildPart(String dirname) {
        return dirname.startsWith(BUILD_PART_PREFIX);
    }

    private static String getLabelPart(String artifactLabel) {
        return artifactLabel == null ? null : StringUtils.replace((String)artifactLabel, (String)" ", (String)"-");
    }

    static boolean isGlobalStorageDirectoryName(String name) {
        return name.startsWith(GLOBAL_STORAGE_DIRECTORY);
    }
}

