/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.storage.location;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class BuildPathUtils {
    private static final String BUILD_RESULTS_FILENAME_PREFIX = "buildresults";
    private static final Pattern BUILD_RESULTS_FILENAME_PATTERN = Pattern.compile("buildresults(\\d+)\\.xml");
    private static final Logger log = Logger.getLogger(BuildPathUtils.class);

    public static String getBuildResultsFilename(long buildNumber) {
        return BUILD_RESULTS_FILENAME_PREFIX + buildNumber + ".xml";
    }

    @Nullable
    public static Integer getBuildResultNumber(String filename) {
        Matcher matcher = BUILD_RESULTS_FILENAME_PATTERN.matcher(filename);
        if (!matcher.matches()) {
            return null;
        }
        String buildNumber = matcher.group(1);
        return NumberUtils.createInteger((String)buildNumber);
    }
}

