/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.storage.location;

import com.atlassian.bamboo.Key;
import com.atlassian.bamboo.ResultKey;
import com.atlassian.bamboo.build.fileserver.BuildDirectoryManager;
import com.atlassian.bamboo.container.PersisterFactory;
import com.atlassian.bamboo.persister.Persister;
import com.atlassian.bamboo.storage.ArtifactDirectoryBuilder;
import com.atlassian.bamboo.storage.ArtifactPathBuilder;
import com.atlassian.bamboo.storage.StorageLocationService;
import com.atlassian.bamboo.storage.location.ArtifactPathBuilderFactory;
import com.atlassian.bamboo.storage.location.StorageTagService;
import com.google.common.base.Preconditions;
import java.io.File;
import javax.inject.Inject;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;

public class StorageLocationServiceImpl
implements StorageLocationService {
    public static final String BUILD_LOGS_DIRECTORY = "build_logs";
    private static final String LOGS_DIRECTORY = "logs";
    private static final String BUILD_RESULTS_DIRECTORY = "results";
    static final String DOWNLOAD_DIRECTORY = "download-data";
    @Inject
    private StorageTagService storageTagService;
    @Inject
    private BuildDirectoryManager buildDirectoryManager;
    @Inject
    private ArtifactPathBuilderFactory artifactPathBuilderFactory;
    @Autowired(required=false)
    private ArtifactDirectoryBuilder defaultArtifactDirectoryBuilder;

    public File getRootBuildDataDirectory() {
        Persister persister = PersisterFactory.getInstance();
        if (persister == null) {
            File buildDirectory = this.buildDirectoryManager.getWorkingDirectoryOfCurrentAgent();
            File dataDir = new File(buildDirectory, LOGS_DIRECTORY);
            dataDir.mkdir();
            return dataDir;
        }
        return persister.getDataDirectoryFile();
    }

    public File getBuildDataDirectory(Key key) {
        return new File(this.getRootBuildDataDirectory(), this.storageTagService.getStorageLabel(key));
    }

    public File getBuildResultsDirectory(Key buildKey) {
        return new File(this.getBuildDataDirectory(buildKey), BUILD_RESULTS_DIRECTORY);
    }

    public File getBuildDownloadDataDirectory(Key key) {
        return new File(this.getBuildDataDirectory(key), DOWNLOAD_DIRECTORY);
    }

    public File getBuildLogsDirectory(Key key) {
        return new File(this.getBuildDownloadDataDirectory(key), BUILD_LOGS_DIRECTORY);
    }

    public String getLogFileName(@NotNull Key entityKey, int resultNumber) {
        return this.getLogFileName(entityKey, (long)resultNumber);
    }

    public String getLogFileName(@NotNull Key entityKey, long resultNumber) {
        String storageLabel = this.storageTagService.getStorageLabel(entityKey);
        return storageLabel + "-" + resultNumber + ".log";
    }

    public String getLogFileName(ResultKey resultKey) {
        return this.getLogFileName(resultKey.getEntityKey(), resultKey.getResultNumberLong());
    }

    public File getLogFile(Key entityKey, int resultNumber) {
        return this.getLogFile(entityKey, (long)resultNumber);
    }

    public File getLogFile(Key entityKey, long resultNumber) {
        return new File(this.getBuildLogsDirectory(entityKey), this.getLogFileName(entityKey, resultNumber));
    }

    public File getLogFile(ResultKey resultKey) {
        return new File(this.getBuildLogsDirectory(resultKey.getEntityKey()), this.getLogFileName(resultKey));
    }

    @NotNull
    public ArtifactDirectoryBuilder getDefaultArtifactDirectoryBuilder() {
        Preconditions.checkState((this.defaultArtifactDirectoryBuilder != null ? 1 : 0) != 0);
        return this.defaultArtifactDirectoryBuilder;
    }

    public ArtifactPathBuilder getArtifactPathBuilder(String rootStoragePath, char separatorChar) {
        return this.artifactPathBuilderFactory.createArtifactPathBuilder(rootStoragePath, separatorChar);
    }

    public ArtifactPathBuilder getArtifactPathBuilder(char separatorChar) {
        return this.artifactPathBuilderFactory.createArtifactPathBuilder(separatorChar);
    }

    public ArtifactDirectoryBuilder getArtifactDirectoryBuilder(File rootStorageDirectory) {
        return this.artifactPathBuilderFactory.createArtifactDirectoryBuilder(rootStorageDirectory);
    }
}

