/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.storage.location;

import com.atlassian.bamboo.chains.Chain;
import com.atlassian.bamboo.chains.ChainStorageTag;
import com.atlassian.bamboo.plan.PlanKey;
import com.atlassian.bamboo.plan.PlanKeys;
import com.atlassian.bamboo.plan.PlanManager;
import com.atlassian.bamboo.plan.cache.CachedPlanManager;
import com.atlassian.bamboo.plan.cache.ImmutableChain;
import com.atlassian.bamboo.storage.location.AbstractStorageTagService;
import com.atlassian.bamboo.storage.location.StorageTagService;
import com.google.common.base.Preconditions;
import javax.inject.Inject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StorageTagServiceImpl
extends AbstractStorageTagService
implements StorageTagService {
    @Inject
    private CachedPlanManager cachedPlanManager;
    @Inject
    private PlanManager planManager;

    @Override
    @Nullable
    public ChainStorageTag getChainStorageTag(@NotNull PlanKey chainKey) {
        Preconditions.checkNotNull((Object)chainKey, (Object)"ChainKey cannot be null");
        Preconditions.checkArgument((!PlanKeys.isJobKey((PlanKey)chainKey) ? 1 : 0) != 0, (Object)("Cannot get storage tag for a PlanKey which is a job key " + chainKey));
        ImmutableChain chain = this.getChain(chainKey);
        if (chain == null) {
            return null;
        }
        return chain.getStorageTag();
    }

    private ImmutableChain getChain(@NotNull PlanKey chainKey) {
        ImmutableChain plan = (ImmutableChain)this.cachedPlanManager.getPlanByKey(chainKey, ImmutableChain.class);
        if (plan != null) {
            return plan;
        }
        return (ImmutableChain)this.planManager.getPlanByKey(chainKey, Chain.class);
    }
}

