/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.storage.notification;

import com.atlassian.bamboo.notification.Notification;
import com.atlassian.bamboo.notification.NotificationDispatcher;
import com.atlassian.bamboo.notification.NotificationFactory;
import com.atlassian.bamboo.notification.NotificationRecipient;
import com.atlassian.bamboo.security.BambooPermissionManager;
import com.atlassian.bamboo.storage.event.ArtifactStorageHardLimitExceededEvent;
import com.atlassian.bamboo.storage.event.ArtifactStorageSoftLimitExceededEvent;
import com.atlassian.bamboo.storage.notification.ArtifactStorageHardLimitExceededNotification;
import com.atlassian.bamboo.storage.notification.ArtifactStorageSoftLimitExceededNotification;
import com.atlassian.bamboo.user.BambooUserManager;
import com.atlassian.bamboo.utils.BambooNotificationUtils;
import com.atlassian.event.api.EventListener;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import javax.inject.Inject;
import org.jetbrains.annotations.NotNull;

public class ArtifactStorageNotificationListener {
    @Inject
    NotificationDispatcher notificationDispatcher;
    @Inject
    NotificationFactory notificationFactory;
    @Inject
    BambooUserManager bambooUserManager;
    @Inject
    BambooPermissionManager bambooPermissionManager;
    private final Predicate<String> isAdmin = new Predicate<String>(){

        public boolean apply(String userName) {
            return ArtifactStorageNotificationListener.this.bambooPermissionManager.isAdmin(userName);
        }
    };

    @EventListener
    public void handleSoftLimitExceeded(@NotNull ArtifactStorageSoftLimitExceededEvent event) {
        this.sendNotification(ArtifactStorageSoftLimitExceededNotification.class, event);
    }

    @EventListener
    public void handleHardLimitExceeded(@NotNull ArtifactStorageHardLimitExceededEvent event) {
        this.sendNotification(ArtifactStorageHardLimitExceededNotification.class, event);
    }

    private void sendNotification(@NotNull Class<? extends Notification> notificationClass, @NotNull Object event) {
        Notification notification = BambooNotificationUtils.createNotification(notificationClass);
        notification.setEvent(event);
        for (String userName : this.getNamesOfUsersToNotify()) {
            notification.addRecipient((NotificationRecipient)this.notificationFactory.getUserRecipient(userName));
        }
        this.notificationDispatcher.dispatchNotifications(notification);
    }

    @NotNull
    private Iterable<String> getNamesOfUsersToNotify() {
        return Iterables.filter((Iterable)this.bambooUserManager.getUserNames(), this.isAdmin);
    }
}

