/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.struts;

import com.atlassian.bamboo.struts.OgnlUtils;
import com.atlassian.bamboo.util.Narrow;
import com.atlassian.bamboo.utils.BambooCollectors;
import com.google.common.base.Preconditions;
import com.opensymphony.xwork2.ActionContext;
import com.opensymphony.xwork2.ActionInvocation;
import com.opensymphony.xwork2.util.ValueStack;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class OgnlStackUtils {
    private OgnlStackUtils() {
    }

    @Nullable
    public static ValueStack getOgnlStack() {
        ActionInvocation actionInvocation = ActionContext.getContext().getActionInvocation();
        return actionInvocation != null ? actionInvocation.getStack() : null;
    }

    @NotNull
    public static Map<String, Object> getOgnlContext() {
        return Collections.unmodifiableMap(OgnlStackUtils.getMutableOgnlContext());
    }

    public static void putAll(Map<String, ? extends Object> map) {
        OgnlStackUtils.getMutableOgnlContext().putAll(map);
    }

    private static Map<String, ?> escape(Map<String, ?> unsafeMap) {
        HashMap safeMap = new HashMap();
        for (Map.Entry<String, ?> entry : unsafeMap.entrySet()) {
            Object value = entry.getValue();
            String unsafeValue = (String)Narrow.downTo(value, String.class);
            if (unsafeValue != null) {
                value = OgnlUtils.ognlLiteral(unsafeValue);
            } else {
                String[] unsafeStrs = (String[])Narrow.downTo(value, String[].class);
                String[] safeStrs = new String[unsafeStrs.length];
                for (int i = 0; i < unsafeStrs.length; ++i) {
                    String unsafeStr = unsafeStrs[i];
                    if (unsafeStr == null) continue;
                    safeStrs[i] = OgnlUtils.ognlLiteral(unsafeStr);
                }
                value = safeStrs;
            }
            safeMap.put(entry.getKey(), value);
        }
        return safeMap;
    }

    public static void putAllIfAbsent(Map<String, Object> map) {
        Map<String, Object> ognlContext = OgnlStackUtils.getMutableOgnlContext();
        Map missingValues = (Map)map.entrySet().stream().filter(entry -> !ognlContext.containsKey(entry.getKey())).collect(BambooCollectors.toMap());
        OgnlStackUtils.putAll(missingValues);
    }

    public static void putAllIfPresent(Map<String, Object> map) {
        Map<String, Object> ognlContext = OgnlStackUtils.getMutableOgnlContext();
        Map presentValues = (Map)map.entrySet().stream().filter(entry -> ognlContext.containsKey(entry.getKey())).collect(BambooCollectors.toMap());
        OgnlStackUtils.putAll(presentValues);
    }

    @NotNull
    private static Map<String, Object> getMutableOgnlContext() {
        ValueStack ognlStack = (ValueStack)Preconditions.checkNotNull((Object)OgnlStackUtils.getOgnlStack());
        return ognlStack.getContext();
    }
}

