/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.struts;

import java.util.regex.Pattern;
import org.apache.commons.text.StringEscapeUtils;

public class OgnlUtils {
    private static final String OGNL_EVALUATION_PREFIX = "%{";
    private static final String ALTERNATE_OGNL_EVALUATION_PREFIX = "${";
    private static final Pattern BAMBOO_VAR_PATTERN = Pattern.compile("\\$\\{bamboo[\\.\\w_:]+\\}");

    private static String removeBambooVariables(String string) {
        return BAMBOO_VAR_PATTERN.matcher(string).replaceAll("");
    }

    static String ognlLiteral(String wrappedObject) {
        return "%{\"" + StringEscapeUtils.escapeJava((String)wrappedObject) + "\"}";
    }

    public static boolean isOgnlExpression(String unsafeString) {
        String unsafeStringWithNoBambooVars = OgnlUtils.removeBambooVariables(unsafeString);
        return unsafeString.contains(OGNL_EVALUATION_PREFIX) || unsafeStringWithNoBambooVars.contains(ALTERNATE_OGNL_EVALUATION_PREFIX);
    }
}

