/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.task;

import com.atlassian.bamboo.build.logger.BuildLogger;
import com.atlassian.bamboo.configuration.ConfigurationMap;
import com.atlassian.bamboo.configuration.ConfigurationMapImpl;
import com.atlassian.bamboo.serialization.WhitelistedSerializable;
import com.atlassian.bamboo.task.CommonTaskContext;
import com.atlassian.bamboo.task.TaskExecutionContext;
import com.atlassian.bamboo.task.TaskRootDirectorySelector;
import com.atlassian.bamboo.task.runtime.RuntimeTaskDefinition;
import com.atlassian.bamboo.v2.build.CommonContext;
import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CommonTaskContextImpl
implements CommonTaskContext {
    private static final Logger log = Logger.getLogger(CommonTaskContextImpl.class);
    private final long id;
    private final String pluginKey;
    private final String userDescription;
    private final boolean isEnabled;
    private final boolean finalising;
    protected final TaskRootDirectorySelector rootDirectorySelector;
    protected final TaskExecutionContext taskExecutionContext;
    private final ConfigurationMap configurationMap;
    private final Map<String, String> runtimeTaskContext;
    private final Map<String, WhitelistedSerializable> runtimeData;
    boolean producesTestResults = false;

    public CommonTaskContextImpl(Map<String, String> substitutedConfiguration, TaskExecutionContext taskExecutionContext, RuntimeTaskDefinition taskDefinition) {
        this.taskExecutionContext = taskExecutionContext;
        this.configurationMap = new ConfigurationMapImpl((Map<String, String>)ImmutableMap.copyOf(substitutedConfiguration));
        this.id = taskDefinition.getId();
        this.userDescription = taskDefinition.getUserDescription();
        this.isEnabled = taskDefinition.isEnabled();
        this.finalising = taskDefinition.isFinalising();
        this.pluginKey = taskDefinition.getPluginKey();
        this.rootDirectorySelector = taskDefinition.getRootDirectorySelector();
        this.producesTestResults = taskDefinition.doesTaskProduceTestResults();
        this.runtimeTaskContext = taskDefinition.getRuntimeContext();
        this.runtimeData = taskDefinition.getRuntimeData();
    }

    public long getId() {
        return this.id;
    }

    @NotNull
    public String getPluginKey() {
        return this.pluginKey;
    }

    public String getUserDescription() {
        return this.userDescription;
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    public boolean isFinalising() {
        return this.finalising;
    }

    @NotNull
    public CommonContext getBuildContext() {
        return this.taskExecutionContext.getCommonContext();
    }

    @NotNull
    public CommonContext getCommonContext() {
        return this.taskExecutionContext.getCommonContext();
    }

    @NotNull
    public BuildLogger getBuildLogger() {
        return this.taskExecutionContext.getBuildLogger();
    }

    @NotNull
    public File getRootDirectory() {
        switch (this.rootDirectorySelector.getTaskRootDirectoryType()) {
            case INHERITED: {
                return this.taskExecutionContext.getRootDirectory();
            }
        }
        return this.taskExecutionContext.getDefaultRootDirectory();
    }

    @NotNull
    public File getWorkingDirectory() {
        String workingSubdirectory = (String)this.getConfigurationMap().get((Object)"workingSubDirectory");
        if (StringUtils.isNotEmpty((CharSequence)workingSubdirectory)) {
            return new File(this.getRootDirectory(), workingSubdirectory);
        }
        return this.getRootDirectory();
    }

    @NotNull
    public ConfigurationMap getConfigurationMap() {
        return this.configurationMap;
    }

    @Nullable
    public Map<String, String> getRuntimeTaskContext() {
        return this.runtimeTaskContext;
    }

    @Nullable
    public Map<String, WhitelistedSerializable> getRuntimeTaskData() {
        return this.runtimeData;
    }

    public boolean doesTaskProduceTestResults() {
        return this.producesTestResults;
    }
}

