/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.task;

import com.atlassian.annotations.Internal;
import com.atlassian.bamboo.task.TaskExecutionStrategy;
import com.atlassian.bamboo.task.TaskResult;
import com.atlassian.bamboo.task.TaskState;
import com.atlassian.bamboo.task.runtime.RuntimeTaskDefinition;
import java.util.Queue;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.Nullable;

@Internal
public class DefaultTaskExecutionStrategy
implements TaskExecutionStrategy {
    private static final Logger log = Logger.getLogger(DefaultTaskExecutionStrategy.class);

    @Override
    public boolean hasTasksToExecute(Queue<RuntimeTaskDefinition> tasks, @Nullable TaskResult lastTaskResult) {
        return this.shouldContinueExecuting(lastTaskResult) && !tasks.isEmpty();
    }

    @Override
    @Nullable
    public RuntimeTaskDefinition nextTask(Queue<RuntimeTaskDefinition> tasks) {
        return tasks.poll();
    }

    private boolean shouldContinueExecuting(@Nullable TaskResult lastTaskResult) {
        return lastTaskResult == null || lastTaskResult.getTaskState() == TaskState.SUCCESS && !lastTaskResult.shouldStopExecution();
    }
}

