/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.task;

import com.atlassian.annotations.Internal;
import com.atlassian.bamboo.core.BambooEntityOid;
import com.atlassian.bamboo.task.TaskConditionConfig;
import com.atlassian.bamboo.task.TaskDefinition;
import com.atlassian.bamboo.task.TaskRootDirectorySelector;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Internal
public class ImmutableTaskDefinition
implements TaskDefinition {
    private final long id;
    private final String pluginKey;
    private final String userDescription;
    private final boolean isEnabled;
    private final ImmutableList<TaskConditionConfig> conditions;
    private final boolean finalizing;
    private final ImmutableMap<String, String> configuration;
    private final TaskRootDirectorySelector taskRootDirectorySelector;
    private final BambooEntityOid oid;

    public ImmutableTaskDefinition(@NotNull TaskDefinition taskDefinition) {
        this.id = taskDefinition.getId();
        this.pluginKey = taskDefinition.getPluginKey();
        this.userDescription = taskDefinition.getUserDescription();
        this.isEnabled = taskDefinition.isEnabled();
        this.conditions = ImmutableList.copyOf((Collection)taskDefinition.getConditions());
        this.finalizing = taskDefinition.isFinalising();
        this.configuration = ImmutableMap.copyOf((Map)taskDefinition.getConfiguration());
        this.taskRootDirectorySelector = taskDefinition.getRootDirectorySelector();
        this.oid = taskDefinition.getOid();
    }

    @NotNull
    public Map<String, String> getConfiguration() {
        return this.configuration;
    }

    public long getId() {
        return this.id;
    }

    @NotNull
    public String getPluginKey() {
        return this.pluginKey;
    }

    @Nullable
    public String getUserDescription() {
        return this.userDescription;
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    public boolean isFinalising() {
        return this.finalizing;
    }

    @NotNull
    public TaskRootDirectorySelector getRootDirectorySelector() {
        return this.taskRootDirectorySelector;
    }

    public BambooEntityOid getOid() {
        return this.oid;
    }

    public void setOid(BambooEntityOid oid) {
        throw new UnsupportedOperationException("TaskDefinition is immutable");
    }

    public void setUserDescription(@Nullable String userDescription) {
        throw new UnsupportedOperationException("TaskDefinition is immutable");
    }

    public void setEnabled(boolean isEnabled) {
        throw new UnsupportedOperationException("TaskDefinition is immutable");
    }

    public void setFinalising(boolean finalising) {
        throw new UnsupportedOperationException("TaskDefinition is immutable");
    }

    public void setConfiguration(@NotNull Map<String, String> configuration) {
        throw new UnsupportedOperationException("TaskDefinition is immutable");
    }

    public void setConditions(@NotNull List<TaskConditionConfig> conditions) {
        throw new UnsupportedOperationException("TaskDefinition is immutable");
    }

    @NotNull
    public List<TaskConditionConfig> getConditions() {
        return this.conditions;
    }

    public void setRootDirectorySelector(@NotNull TaskRootDirectorySelector taskRootDirectorySelector) {
        throw new UnsupportedOperationException("TaskDefinition is immutable");
    }
}

