/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.task;

import com.atlassian.bamboo.FeatureManager;
import com.atlassian.bamboo.configuration.AdministrationConfigurationAccessor;
import com.atlassian.bamboo.task.QuarantineExpiryCleanupJob;
import com.atlassian.bamboo.task.QuarantineExpiryCleanupScheduler;
import org.apache.log4j.Logger;
import org.quartz.CronExpression;
import org.quartz.CronScheduleBuilder;
import org.quartz.CronTrigger;
import org.quartz.JobBuilder;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.TriggerKey;

public class QuarantineExpiryCleanupSchedulerImpl
implements QuarantineExpiryCleanupScheduler {
    private static final Logger log = Logger.getLogger(QuarantineExpiryCleanupSchedulerImpl.class);
    private static final String QUARANTINE_EXPIRY_JOB = "quarantineExpiryCleanupJob";
    private static final String QUARANTINE_EXPIRY_GROUP = "quarantineExpiryCleanupGroup";
    private static final String QUARANTINE_EXPIRY_TRIGGER = "quarantineExpiryCleanupTrigger";
    private static final TriggerKey TRIGGER_KEY = new TriggerKey("quarantineExpiryCleanupTrigger", "quarantineExpiryCleanupGroup");
    private final Scheduler quartzScheduler;
    private final AdministrationConfigurationAccessor administrationConfigurationAccessor;
    private final FeatureManager featureManager;

    public QuarantineExpiryCleanupSchedulerImpl(Scheduler quartzScheduler, AdministrationConfigurationAccessor administrationConfigurationAccessor, FeatureManager featureManager) {
        this.quartzScheduler = quartzScheduler;
        this.administrationConfigurationAccessor = administrationConfigurationAccessor;
        this.featureManager = featureManager;
    }

    public void initialiseSchedule() {
        if (this.featureManager.isLimitedTimeQuarantineEnabled()) {
            this.unschedule();
            this.schedule();
        }
    }

    private void unschedule() {
        try {
            this.quartzScheduler.unscheduleJob(TRIGGER_KEY);
        }
        catch (Exception e) {
            log.warn((Object)"Unable to unschedule quarantineExpiryCleanupJob", (Throwable)e);
        }
    }

    private void schedule() {
        try {
            String cronExpressionStr = this.administrationConfigurationAccessor.getAdministrationConfiguration().getQuarantineConfiguration().getCronExpression();
            JobKey jobKey = new JobKey(QUARANTINE_EXPIRY_JOB, QUARANTINE_EXPIRY_GROUP);
            JobDetail jobDetail = JobBuilder.newJob(QuarantineExpiryCleanupJob.class).withIdentity(jobKey).build();
            CronExpression cronExpression = new CronExpression(cronExpressionStr);
            CronTrigger cronTrigger = (CronTrigger)TriggerBuilder.newTrigger().withIdentity(TRIGGER_KEY).withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((CronExpression)cronExpression)).forJob(jobKey).build();
            this.quartzScheduler.scheduleJob(jobDetail, (Trigger)cronTrigger);
            log.info((Object)("Quarantine expiry cleanup running according to CRON expression: " + cronExpressionStr));
        }
        catch (Exception e) {
            log.error((Object)"Unable to schedule quarantineExpiryCleanupJob", (Throwable)e);
        }
    }
}

