/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.task;

import com.atlassian.bamboo.resultsummary.tests.TestQuarantineHelper;
import com.atlassian.bamboo.task.TaskContext;
import com.atlassian.bamboo.task.TaskDefinition;
import com.atlassian.bamboo.task.TaskResult;
import com.atlassian.bamboo.task.TaskResultProcessor;
import com.atlassian.bamboo.task.TaskState;
import com.atlassian.bamboo.v2.build.CurrentBuildResult;
import com.atlassian.plugin.PluginAccessor;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.jetbrains.annotations.NotNull;

public class QuarantineTaskResultProcessor
implements TaskResultProcessor {
    private final PluginAccessor pluginAccessor;

    public QuarantineTaskResultProcessor(PluginAccessor pluginAccessor) {
        this.pluginAccessor = pluginAccessor;
    }

    @NotNull
    public TaskState recalculateTaskState(TaskContext taskContext, TaskResult taskResult, TaskDefinition taskDefinition) {
        if (taskResult.getTaskState() == TaskState.SUCCESS) {
            return taskResult.getTaskState();
        }
        boolean hasTests = taskContext.doesTaskProduceTestResults();
        if (!hasTests) {
            return taskResult.getTaskState();
        }
        CurrentBuildResult buildResult = taskContext.getBuildContext().getBuildResult();
        Set testsToPass = TestQuarantineHelper.getQuarantinedTests((Map)buildResult.getCustomBuildData());
        if (testsToPass.isEmpty()) {
            return taskResult.getTaskState();
        }
        Collection failedTestResults = buildResult.getFailedTestResults();
        if (CollectionUtils.isEmpty((Collection)failedTestResults)) {
            return taskResult.getTaskState();
        }
        assert (failedTestResults != null);
        if (TestQuarantineHelper.containsAll((Set)testsToPass, (Collection)failedTestResults)) {
            taskContext.getBuildLogger().addBuildLogEntry("Changing Task Result to SUCCESS as all failed tests were quarantined.");
            return TaskState.SUCCESS;
        }
        return taskResult.getTaskState();
    }
}

